/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.items.ItemClipboard;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ItemSettingMessage
implements IMessage {
    public String settingName;
    public int settingValue;

    public void setSetting(String name, int value) {
        this.settingName = name;
        this.settingValue = value;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.settingName);
        buf.writeInt(this.settingValue);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.settingName = buf.m_130136_(Short.MAX_VALUE);
        this.settingValue = buf.readInt();
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (stack == null || !(stack.m_41720_() instanceof ItemClipboard)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(this.settingName, this.settingValue);
        stack.m_41751_(tag);
        player.m_150109_().m_6596_();
        player.f_36096_.m_38946_();
    }
}

