/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public abstract class AbstractBuildingServerMessage<T extends IBuilding>
extends AbstractColonyServerMessage {
    private BlockPos buildingId;

    public AbstractBuildingServerMessage() {
    }

    public AbstractBuildingServerMessage(IBuildingView building) {
        this(building.getColony().getDimension(), building.getColony().getID(), building.getID());
    }

    public AbstractBuildingServerMessage(ResourceKey<Level> dimensionId, int colonyId, BlockPos buildingId) {
        super(dimensionId, colonyId);
        this.buildingId = buildingId;
    }

    public boolean errorIfCastFails() {
        return true;
    }

    protected abstract void onExecute(NetworkEvent.Context var1, boolean var2, IColony var3, T var4);

    @Override
    protected final void toBytesAbstractOverride(FriendlyByteBuf buf) {
        buf.m_130064_(this.buildingId);
    }

    @Override
    protected final void fromBytesAbstractOverride(FriendlyByteBuf buf) {
        this.buildingId = buf.m_130135_();
    }

    @Override
    public final void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        block3: {
            IBuilding building = colony.getBuildingManager().getBuilding(this.buildingId);
            if (building == null) {
                return;
            }
            try {
                this.onExecute(ctxIn, isLogicalServer, colony, building);
            }
            catch (ClassCastException e) {
                if (!this.errorIfCastFails()) break block3;
                Log.getLogger().warn("onExecute called with wrong type: ", (Throwable)e);
            }
        }
    }
}

