/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.blocks.MinecoloniesFarmland;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class ItemCrop
extends BlockItem {
    @Nullable
    private final TagKey<Biome> preferredBiome;

    public ItemCrop(@NotNull MinecoloniesCropBlock cropBlock, @NotNull Item.Properties builder, @Nullable TagKey<Biome> preferredBiome) {
        super((Block)cropBlock, builder.m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.3f).m_38767_()));
        this.preferredBiome = preferredBiome;
    }

    protected boolean m_40610_(BlockPlaceContext ctx, @NotNull BlockState state) {
        Player player = ctx.m_43723_();
        if (!player.m_7500_()) {
            BlockPos clickedPos = ctx.m_8083_().m_7495_();
            BlockState worldState = ctx.m_43725_().m_8055_(clickedPos);
            if (ctx.m_43725_().f_46443_ && (worldState.m_60734_() instanceof MinecoloniesFarmland || worldState.m_60734_() instanceof FarmBlock)) {
                MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.crop.cantplant")).sendTo(player);
            }
            return false;
        }
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.m_6652_() || state.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) && ctx.m_43725_().m_45752_(state, ctx.m_8083_(), collisioncontext);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"com.minecolonies.core.item.crop.tooltip").m_130940_(ChatFormatting.GRAY));
        if (this.preferredBiome != null && worldIn != null) {
            tooltip.add((Component)Component.m_237115_((String)("com.minecolonies.core.item.crop.tooltip.biome." + this.preferredBiome.f_203868_().m_135815_())));
            if (worldIn.m_204166_(Minecraft.m_91087_().f_91074_.m_20183_()).m_203656_(this.preferredBiome)) {
                tooltip.add((Component)Component.m_237115_((String)"com.minecolonies.core.item.crop.tooltip.biome.match").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"com.minecolonies.core.item.crop.tooltip.biome.nomatch").m_130940_(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"com.minecolonies.core.item.crop.tooltip.hoe").m_130940_(ChatFormatting.DARK_AQUA).m_130940_(ChatFormatting.ITALIC));
    }

    public boolean canBePlantedIn(Holder<Biome> biome) {
        return this.preferredBiome == null || biome.m_203656_(this.preferredBiome);
    }
}

