/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.map.WindowColonyMap;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemColonyMap
extends AbstractItemMinecolonies {
    public static final String TAG_COLONY = "colony";

    public ItemColonyMap(Item.Properties properties) {
        super("colonymap", properties.m_41487_(64));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack map = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = ItemColonyMap.checkForCompound(map);
        BlockEntity entity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (entity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
            compound.m_128405_(TAG_COLONY, buildingEntity.getColonyId());
            if (!ctx.m_43725_().f_46443_) {
                MessageUtils.format("com.minecolonies.core.item.colonymap.registered", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
            }
        } else if (ctx.m_43725_().f_46443_) {
            ItemColonyMap.openWindow(compound, ctx.m_43725_(), ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack map = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)map);
        }
        ItemColonyMap.openWindow(ItemColonyMap.checkForCompound(map), worldIn, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)map);
    }

    private static CompoundTag checkForCompound(ItemStack map) {
        if (!map.m_41782_()) {
            map.m_41751_(new CompoundTag());
        }
        return map.m_41783_();
    }

    private static void openWindow(CompoundTag compound, Level world, Player player) {
        if (compound.m_128441_(TAG_COLONY)) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(compound.m_128451_(TAG_COLONY), (ResourceKey<Level>)world.m_46472_());
            if (colonyView != null && colonyView.getTownHall() != null) {
                new WindowColonyMap(false, colonyView.getTownHall()).open();
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"com.minecolonies.core.item.colonymap.needcolony"), true);
        }
    }
}

