/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ColonyStoryListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ResourceLocation ABANDONED_COLONY_NAME = new ResourceLocation("minecolonies", "abandoned_name");
    public static final ResourceLocation ABANDONED_COLONY_STORY = new ResourceLocation("minecolonies", "abandoned");
    public static final ResourceLocation SUPPLY_CAMP_STORY = new ResourceLocation("minecolonies", "camp");
    public static final ResourceLocation SUPPLY_SHIP_STORY = new ResourceLocation("minecolonies", "ship");
    public static Set<StoryText> abandonedColonyNames = new HashSet<StoryText>();
    public static Set<StoryText> abandonedColonyStories = new HashSet<StoryText>();
    public static Set<StoryText> supplyShipStories = new HashSet<StoryText>();
    public static Set<StoryText> supplyCampStories = new HashSet<StoryText>();

    @SubscribeEvent
    public static void modInitClient(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ColonyStoryListener());
    }

    public ColonyStoryListener() {
        super(GSON, "colony/stories");
    }

    public static String pickRandom(Collection<StoryText> stories, Holder<Biome> biome, Random rng) {
        List<String> matches = StoryText.allMatches(stories, biome);
        if (matches.isEmpty()) {
            return "";
        }
        return matches.get(rng.nextInt(matches.size()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        abandonedColonyNames.clear();
        abandonedColonyStories.clear();
        supplyShipStories.clear();
        supplyCampStories.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            try {
                if (entry.getValue().isJsonArray()) {
                    entry.getValue().getAsJsonArray().forEach(e -> this.parseStory(e.getAsJsonObject()));
                    continue;
                }
                this.parseStory(entry.getValue().getAsJsonObject());
            }
            catch (Throwable e2) {
                Log.getLogger().error("Error parsing story " + entry.getKey().toString(), e2);
            }
        }
    }

    private void parseStory(JsonObject json) {
        ResourceLocation type = new ResourceLocation(((JsonElement)Objects.requireNonNullElse(json.get("type"), new JsonPrimitive(""))).getAsString());
        if (type.equals((Object)ABANDONED_COLONY_NAME)) {
            abandonedColonyNames.addAll(this.parseStoryText(json));
        } else if (type.equals((Object)ABANDONED_COLONY_STORY)) {
            abandonedColonyStories.addAll(this.parseStoryText(json));
        } else if (type.equals((Object)SUPPLY_CAMP_STORY)) {
            supplyCampStories.addAll(this.parseStoryText(json));
        } else if (type.equals((Object)SUPPLY_SHIP_STORY)) {
            supplyShipStories.addAll(this.parseStoryText(json));
        }
    }

    private List<StoryText> parseStoryText(JsonObject json) {
        JsonElement contentJson;
        BiomeFilter biomeFilter = BiomeFilter.ALL;
        JsonElement biomesJson = json.get("biomes");
        if (biomesJson != null) {
            if (biomesJson.isJsonArray()) {
                for (JsonElement element : biomesJson.getAsJsonArray()) {
                    biomeFilter = biomeFilter.or(BiomeFilter.parse(element.getAsString()));
                }
            } else {
                biomeFilter = BiomeFilter.parse(biomesJson.getAsString());
            }
        }
        if ((contentJson = json.get("content")).isJsonArray()) {
            ArrayList<StoryText> stories = new ArrayList<StoryText>();
            for (JsonElement element : contentJson.getAsJsonArray()) {
                stories.add(new StoryText(biomeFilter, element.getAsString()));
            }
            return stories;
        }
        return Collections.singletonList(new StoryText(biomeFilter, contentJson.getAsString()));
    }

    public record StoryText(BiomeFilter biomeFilter, String content) {
        public boolean matches(Holder<Biome> biome) {
            return this.biomeFilter.test(biome);
        }

        public static List<String> allMatches(Collection<StoryText> stories, Holder<Biome> biome) {
            return stories.stream().filter(s -> s.matches(biome)).map(StoryText::content).toList();
        }
    }

    private record BiomeFilter(Predicate<Holder<Biome>> filter) implements Predicate<Holder<Biome>>
    {
        public static final BiomeFilter ALL = new BiomeFilter(b -> true);

        public BiomeFilter or(BiomeFilter other) {
            return this == ALL ? other : (other == ALL ? this : new BiomeFilter(this.filter().or(other.filter())));
        }

        @Override
        public boolean test(Holder<Biome> biome) {
            return this.filter.test(biome);
        }

        public static BiomeFilter parse(String value) {
            if (value.startsWith("#")) {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(value.substring(1)));
                return new BiomeFilter(b -> b.m_203656_(tagKey));
            }
            RegistryAccess.Frozen registryAccess = ServerLifecycleHooks.getCurrentServer().m_206579_();
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(value));
            Holder.Reference biome = registryAccess.m_175515_(Registries.f_256952_).m_246971_(key);
            return new BiomeFilter(arg_0 -> BiomeFilter.lambda$parse$2((Holder)biome, arg_0));
        }

        private static /* synthetic */ boolean lambda$parse$2(Holder biome, Holder b) {
            return b.equals(biome);
        }
    }
}

