/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PathJobMoveTowards
extends AbstractPathJob
implements IDestinationPathJob {
    protected final BlockPos target;
    protected final int minDistance;

    public PathJobMoveTowards(Level world, @NotNull BlockPos start, @NotNull BlockPos direction, int minDistance, Mob entity) {
        super(world, start, minDistance * 2, new PathResult(), entity);
        this.target = direction;
        this.minDistance = minDistance;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.target, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z) > this.minDistance && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    public BlockPos getDestination() {
        return this.target;
    }
}

