/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.util.ExperienceUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenSkillHandler
implements ICitizenSkillHandler {
    public Map<Skill, SkillData> skillMap = new EnumMap<Skill, SkillData>(Skill.class);

    public CitizenSkillHandler() {
        for (Skill skill : Skill.values()) {
            this.skillMap.put(skill, new SkillData(1, 0.0));
        }
    }

    @Override
    public void init(int levelCap) {
        if (levelCap <= 1) {
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, new SkillData(1, 0.0));
            }
        } else {
            Random random = new Random();
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, new SkillData(random.nextInt(levelCap - 1) + 1, 0.0));
            }
        }
    }

    @Override
    public void init(@NotNull IColony colony, @Nullable ICitizenData firstParent, @Nullable ICitizenData secondParent, Random rand) {
        ICitizenData roleModelA = firstParent == null ? colony.getCitizenManager().getRandomCitizen() : firstParent;
        ICitizenData roleModelB = secondParent == null ? colony.getCitizenManager().getRandomCitizen() : secondParent;
        int levelCap = (int)colony.getOverallHappiness();
        this.init(levelCap);
        int bonusPoints = 25 + rand.nextInt(25);
        int totalPoints = 0;
        for (Skill skill : Skill.values()) {
            int firstRoleModelLevel = roleModelA.getCitizenSkillHandler().getSkills().get((Object)((Object)skill)).level;
            int secondRoleModelLevel = roleModelB.getCitizenSkillHandler().getSkills().get((Object)((Object)skill)).level;
            totalPoints += firstRoleModelLevel + secondRoleModelLevel;
        }
        for (Skill skill : Skill.values()) {
            double firstRoleModelLevel = roleModelA.getCitizenSkillHandler().getSkills().get((Object)((Object)skill)).level;
            double secondRoleModelLevel = roleModelB.getCitizenSkillHandler().getSkills().get((Object)((Object)skill)).level;
            int newPoints = (int)((firstRoleModelLevel + secondRoleModelLevel) / (double)totalPoints * (double)bonusPoints);
            this.skillMap.get((Object)((Object)skill)).level += newPoints;
        }
    }

    @Override
    @NotNull
    public CompoundTag write() {
        CompoundTag compoundNBT = new CompoundTag();
        @NotNull ListTag levelTagList = new ListTag();
        for (Map.Entry<Skill, SkillData> entry : this.skillMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            @NotNull CompoundTag levelCompound = new CompoundTag();
            levelCompound.m_128405_("skill", entry.getKey().ordinal());
            levelCompound.m_128405_("level", entry.getValue().level);
            levelCompound.m_128347_("experience", entry.getValue().experience);
            levelTagList.add((Object)levelCompound);
        }
        compoundNBT.m_128365_("levelMap", (Tag)levelTagList);
        return compoundNBT;
    }

    @Override
    public void read(@NotNull CompoundTag compoundNBT) {
        ListTag levelTagList = compoundNBT.m_128437_("levelMap", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            CompoundTag levelExperienceAtJob = levelTagList.m_128728_(i);
            this.skillMap.put(Skill.values()[levelExperienceAtJob.m_128451_("skill")], new SkillData(Math.max(1, Math.min(levelExperienceAtJob.m_128451_("level"), 99)), levelExperienceAtJob.m_128459_("experience")));
        }
    }

    @Override
    public boolean tryLevelUpIntelligence(@NotNull Random random, double customChance, @NotNull ICitizenData citizen) {
        if (customChance > 0.0 && random.nextDouble() * customChance < 1.0) {
            return false;
        }
        int levelCap = (int)citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen);
        if (this.skillMap.get((Object)((Object)Skill.Intelligence)).level < levelCap * 9) {
            this.addXpToSkill(Skill.Intelligence, 10.0, citizen);
        }
        return true;
    }

    @Override
    public int getLevel(@NotNull Skill skill) {
        return this.skillMap.get((Object)((Object)skill)).level;
    }

    @Override
    public void incrementLevel(@NotNull Skill skill, int level) {
        SkillData current = this.skillMap.get((Object)skill);
        current.level = Math.min(99, Math.max(current.level + level, 1));
    }

    @Override
    public void addXpToSkill(Skill skill, double xp, ICitizenData data) {
        double citizenHutMaxLevel;
        SkillData skillData = this.skillMap.getOrDefault((Object)skill, new SkillData(0, 0.0));
        IBuilding home = data.getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevelEquivalent();
        double d = citizenHutMaxLevel = home == null ? 5.0 : (double)home.getMaxBuildingLevel();
        if ((citizenHutLevel < citizenHutMaxLevel || citizenHutMaxLevel < 5.0) && (citizenHutLevel + 1.0) * 10.0 <= (double)skillData.level || skillData.level >= 99) {
            return;
        }
        int orgLevel = skillData.level;
        double xpToLevelUp = Math.min(Double.MAX_VALUE, skillData.experience + xp);
        while (xpToLevelUp > 0.0) {
            double nextLevel = ExperienceUtils.getXPNeededForNextLevel(skillData.level);
            if (nextLevel > xpToLevelUp) {
                skillData.experience = xpToLevelUp;
                break;
            }
            xpToLevelUp -= nextLevel;
            ++skillData.level;
        }
        if (skillData.level > orgLevel) {
            this.levelUp(data);
            data.markDirty(10);
        }
    }

    @Override
    public void removeXpFromSkill(@NotNull Skill skill, double xp, @NotNull ICitizenData data) {
        SkillData skillData = this.skillMap.get((Object)skill);
        double xpToRemove = xp;
        while (xpToRemove > 0.0) {
            if (skillData.experience >= xpToRemove || skillData.level <= 1) {
                skillData.experience = Math.max(0.0, skillData.experience - xpToRemove);
                break;
            }
            xpToRemove -= skillData.experience;
            skillData.experience = ExperienceUtils.getXPNeededForNextLevel(skillData.level - 1);
            --skillData.level;
            data.markDirty(40);
        }
    }

    @Override
    public void levelUp(ICitizenData data) {
        if (data.getEntity().isPresent()) {
            AbstractEntityCitizen citizen = data.getEntity().get();
            SoundUtils.playSoundAtCitizenWith(citizen.f_19853_, citizen.m_20183_(), EventType.SUCCESS, data);
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(citizen.m_20185_(), citizen.m_20186_(), citizen.m_20189_(), ParticleTypes.f_123748_), (Entity)data.getEntity().get());
        }
        if (data.getJob() != null) {
            data.getJob().onLevelUp();
        }
    }

    @Override
    public double getTotalXP() {
        double totalXp = 0.0;
        for (SkillData tuple : this.skillMap.values()) {
            totalXp += tuple.experience;
        }
        return totalXp;
    }

    @Override
    public Map<Skill, SkillData> getSkills() {
        return Collections.unmodifiableMap(this.skillMap);
    }

    public static class SkillData {
        private int level;
        private double experience;

        private SkillData(int level, double experience) {
            this.level = level;
            this.experience = experience;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public double getExperience() {
            return this.experience;
        }

        public void setExperience(double experience) {
            this.experience = experience;
        }
    }
}

