/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.SittingEntity;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntityAICitizenWander
implements IStateAI {
    private static final int LEISURE_CHANCE = 5;
    protected final EntityCitizen citizen;
    protected final double speed;
    private BlockPos walkTo;
    private BlockPos leisureSite;

    public EntityAICitizenWander(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.IDLE, () -> true, this::decide, 100));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(WanderState.GO_TO_LEISURE_SITE, () -> true, this::goToLeisureSite, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(WanderState.WANDER_AT_LEISURE_SITE, () -> true, this::wanderAtLeisureSite, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(WanderState.READ_A_BOOK, () -> true, this::readABook, 20));
    }

    private IState readABook() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return CitizenAIState.IDLE;
        }
        if (this.walkTo != null) {
            if (!EntityNavigationUtils.walkToPos(this.citizen, this.walkTo, 3, true)) {
                return WanderState.READ_A_BOOK;
            }
            if (this.citizen.m_217043_().m_188503_(100) < 5) {
                this.citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.walkTo = null;
                this.leisureSite = null;
                this.citizen.getCitizenData().getCitizenSkillHandler().tryLevelUpIntelligence(this.citizen.getCitizenData().getRandom(), 8.0, this.citizen.getCitizenData());
                return CitizenAIState.IDLE;
            }
            this.citizen.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42517_));
            return WanderState.READ_A_BOOK;
        }
        BlockEntity blockEntity = this.citizen.f_19853_.m_7702_(this.leisureSite);
        if (blockEntity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding tileEntityColonyBuilding = (TileEntityColonyBuilding)blockEntity;
            IBuilding iBuilding = tileEntityColonyBuilding.getBuilding();
            if (iBuilding instanceof BuildingLibrary) {
                BuildingLibrary buildingLibrary = (BuildingLibrary)iBuilding;
                this.walkTo = buildingLibrary.getRandomBookShelf();
            } else {
                iBuilding = tileEntityColonyBuilding.getBuilding();
                if (iBuilding instanceof BuildingUniversity) {
                    BuildingUniversity buildingUniversity = (BuildingUniversity)iBuilding;
                    this.walkTo = buildingUniversity.getRandomBookShelf();
                }
            }
        }
        return WanderState.READ_A_BOOK;
    }

    private IState goToLeisureSite() {
        if (this.leisureSite == null) {
            this.walkTo = null;
            return CitizenAIState.IDLE;
        }
        if (!EntityNavigationUtils.walkToPos(this.citizen, this.leisureSite, 3, true)) {
            return WanderState.GO_TO_LEISURE_SITE;
        }
        return WanderState.WANDER_AT_LEISURE_SITE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IState wanderAtLeisureSite() {
        if (this.leisureSite == null || this.citizen.m_217043_().m_188503_(300) < 1) {
            this.leisureSite = null;
            this.walkTo = null;
            return CitizenAIState.IDLE;
        }
        if (this.walkTo != null && !EntityNavigationUtils.walkToPos(this.citizen, this.walkTo, 3, true)) {
            return WanderState.WANDER_AT_LEISURE_SITE;
        }
        BlockEntity blockEntity = this.citizen.f_19853_.m_7702_(this.leisureSite);
        if (!(blockEntity instanceof IBlueprintDataProviderBE)) return CitizenAIState.IDLE;
        if (this.walkTo == null && this.citizen.m_217043_().m_188503_(10) <= 0) {
            EntityNavigationUtils.walkToRandomPosWithin(this.citizen, 10, 0.6, (Tuple<BlockPos, BlockPos>)((IBlueprintDataProviderBE)blockEntity).getInWorldCorners(), this.citizen.f_19853_.m_46471_());
            this.citizen.getCitizenAI().setCurrentDelay(30);
            return WanderState.WANDER_AT_LEISURE_SITE;
        } else {
            if (this.walkTo == null && blockEntity instanceof TileEntityColonyBuilding && (((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingLibrary || ((TileEntityColonyBuilding)blockEntity).getBuilding() instanceof BuildingUniversity) && this.citizen.m_217043_().m_188503_(100) < 5) {
                return WanderState.READ_A_BOOK;
            }
            Map map = ((IBlueprintDataProviderBE)blockEntity).getWorldTagNamePosMap();
            ArrayList sittingPos = new ArrayList(map.getOrDefault("sit", Collections.emptySet()));
            ArrayList insideSittingPos = new ArrayList(map.getOrDefault("sit_in", Collections.emptySet()));
            ArrayList outsideSittingPos = new ArrayList(map.getOrDefault("sit_out", Collections.emptySet()));
            ArrayList insideStandingPos = new ArrayList(map.getOrDefault("stand_in", Collections.emptySet()));
            ArrayList outsideStandingPos = new ArrayList(map.getOrDefault("stand_out", Collections.emptySet()));
            if (this.walkTo == null) {
                if (this.citizen.f_19853_.m_46471_() || MathUtils.RANDOM.nextBoolean()) {
                    if (!insideSittingPos.isEmpty() && MathUtils.RANDOM.nextBoolean()) {
                        this.walkTo = (BlockPos)insideSittingPos.get(this.citizen.m_217043_().m_188503_(insideSittingPos.size()));
                        if (!SittingEntity.isSittingPosOccupied(this.walkTo, this.citizen.f_19853_)) return WanderState.WANDER_AT_LEISURE_SITE;
                        this.walkTo = null;
                    } else if (!insideStandingPos.isEmpty()) {
                        this.walkTo = (BlockPos)insideStandingPos.get(this.citizen.m_217043_().m_188503_(insideStandingPos.size()));
                        return WanderState.WANDER_AT_LEISURE_SITE;
                    }
                }
                if (!outsideSittingPos.isEmpty() && MathUtils.RANDOM.nextBoolean()) {
                    this.walkTo = (BlockPos)outsideSittingPos.get(this.citizen.m_217043_().m_188503_(outsideSittingPos.size()));
                    if (!SittingEntity.isSittingPosOccupied(this.walkTo, this.citizen.f_19853_)) return WanderState.WANDER_AT_LEISURE_SITE;
                    this.walkTo = null;
                } else if (!outsideStandingPos.isEmpty()) {
                    this.walkTo = (BlockPos)outsideStandingPos.get(this.citizen.m_217043_().m_188503_(outsideStandingPos.size()));
                    return WanderState.WANDER_AT_LEISURE_SITE;
                }
                if (sittingPos.isEmpty()) return WanderState.WANDER_AT_LEISURE_SITE;
                this.walkTo = (BlockPos)sittingPos.get(this.citizen.m_217043_().m_188503_(sittingPos.size()));
                if (!SittingEntity.isSittingPosOccupied(this.walkTo, this.citizen.f_19853_)) return WanderState.WANDER_AT_LEISURE_SITE;
                this.walkTo = null;
                return WanderState.WANDER_AT_LEISURE_SITE;
            } else {
                if (sittingPos.contains(this.walkTo) || insideSittingPos.contains(this.walkTo) || outsideSittingPos.contains(this.walkTo)) {
                    SittingEntity.sitDown(this.walkTo, (Mob)this.citizen, 600);
                }
                this.citizen.getCitizenAI().setCurrentDelay(600);
                this.walkTo = null;
            }
        }
        return WanderState.WANDER_AT_LEISURE_SITE;
    }

    private IState decide() {
        if (!this.canUse()) {
            return CitizenAIState.IDLE;
        }
        int randomBit = this.citizen.m_217043_().m_188503_(100);
        if (randomBit < 5) {
            this.leisureSite = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getRandomLeisureSite();
            if (this.leisureSite == null) {
                this.leisureSite = this.citizen.getCitizenData().getHomeBuilding() != null ? this.citizen.getCitizenData().getHomeBuilding().getPosition() : this.citizen.getCitizenColonyHandler().getColonyOrRegister().getCenter();
            }
            if (this.leisureSite != null) {
                this.citizen.getCitizenAI().setCurrentDelay(1200);
                return WanderState.GO_TO_LEISURE_SITE;
            }
        }
        EntityNavigationUtils.walkToRandomPos(this.citizen, 10, this.speed);
        return CitizenAIState.IDLE;
    }

    public boolean canUse() {
        return this.citizen.getNavigation().m_26571_() && !this.citizen.m_6162_() && !(this.citizen.getCitizenData().getJob() instanceof AbstractJobGuard);
    }

    public static enum WanderState implements IState
    {
        GO_TO_LEISURE_SITE,
        WANDER_AT_LEISURE_SITE,
        READ_A_BOOK;

    }
}

