/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei.transfer;

import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.containers.WindowCrafting;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.transfer.AbstractTeachingGuiHandler;
import com.minecolonies.core.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingGuiHandler
extends AbstractTeachingGuiHandler<WindowCrafting> {
    public CraftingGuiHandler(@NotNull List<JobBasedRecipeCategory<?>> categories) {
        super(categories);
    }

    @Override
    @NotNull
    protected Class<WindowCrafting> getWindowClass() {
        return WindowCrafting.class;
    }

    @NotNull
    public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull WindowCrafting containerScreen, double mouseX, double mouseY) {
        ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
        JobBasedRecipeCategory<?> category = this.getRecipeCategory(containerScreen.getBuildingView());
        if (category != null) {
            areas.add(IGuiClickableArea.createBasic((int)90, (int)34, (int)22, (int)17, (RecipeType[])new RecipeType[]{category.getRecipeType()}));
        }
        return areas;
    }

    @Override
    protected boolean isSupportedCraftingModule(@NotNull CraftingModuleView moduleView) {
        return moduleView.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get());
    }

    @Override
    protected boolean isSupportedSlot(@NotNull Slot slot) {
        return slot.f_40218_ instanceof CraftingContainer;
    }

    @Override
    protected void updateServer(@NotNull WindowCrafting gui) {
        HashMap<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
        CraftingContainer inventory = ((ContainerCrafting)gui.m_6262_()).getInv();
        if (gui.isCompleteCrafting()) {
            for (int i = 0; i < 9; ++i) {
                matrix.put(i, inventory.m_8020_(i));
            }
        } else {
            matrix.put(0, inventory.m_8020_(0));
            matrix.put(1, inventory.m_8020_(1));
            matrix.put(3, inventory.m_8020_(2));
            matrix.put(4, inventory.m_8020_(3));
        }
        TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(matrix, gui.isCompleteCrafting());
        Network.getNetwork().sendToServer(message);
    }
}

