/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import com.minecolonies.core.util.AdvancementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuilding
extends AbstractWorkOrder {
    private static final String TAG_CUSTOM_NAME = "customName";
    private static final String TAG_CUSTOM_PARENT_NAME = "customParentName";
    private static final String TAG_PARENT_TRANSLATION_KEY = "parentTranslationKey";
    private static final double MAX_DISTANCE_SQ = 10000.0;
    private String customName;
    private String customParentName;
    private String parentTranslationKey;

    public static WorkOrderBuilding create(@NotNull WorkOrderType type, @NotNull IBuilding building) {
        int targetLevel = building.getBuildingLevel();
        switch (type) {
            case BUILD: {
                targetLevel = 1;
                break;
            }
            case UPGRADE: {
                ++targetLevel;
                break;
            }
            case REMOVE: {
                targetLevel = 0;
            }
        }
        int targetSchematicLevel = type == WorkOrderType.REMOVE ? building.getBuildingLevel() : targetLevel;
        Object schemPath = building.getBlueprintPath().replace(".blueprint", "");
        schemPath = ((String)schemPath).substring(0, ((String)schemPath).length() - 1) + targetSchematicLevel + ".blueprint";
        WorkOrderBuilding wo = new WorkOrderBuilding(building.getStructurePack(), (String)schemPath, building.getBuildingType().getTranslationKey(), type, building.getID(), building.getRotation(), building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored(), building.getBuildingLevel(), targetLevel);
        wo.setCustomName(building);
        wo.setColony(building.getColony());
        return wo;
    }

    public WorkOrderBuilding() {
    }

    private WorkOrderBuilding(String packName, String path, String translationKey, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        super(packName, path, translationKey, workOrderType, location, rotation, isMirrored, currentLevel, targetLevel);
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getCustomParentName() {
        return this.customParentName;
    }

    public String getParentTranslationKey() {
        return this.parentTranslationKey;
    }

    public void setCustomName(@NotNull IBuilding building) {
        IBuilding parentBuilding;
        this.customName = building.getCustomName();
        this.customParentName = "";
        this.parentTranslationKey = "";
        if (building.hasParent() && (parentBuilding = building.getColony().getBuildingManager().getBuilding(building.getParent())) != null) {
            this.customParentName = parentBuilding.getCustomName();
            this.parentTranslationKey = parentBuilding.getBuildingType().getTranslationKey();
        }
    }

    @Override
    public Component getDisplayName() {
        MutableComponent buildingComponent;
        String customParentName = this.getCustomParentName();
        String customName = this.getCustomName();
        MutableComponent mutableComponent = buildingComponent = customName.isEmpty() ? Component.m_237115_((String)this.getTranslationKey()) : Component.m_237113_((String)customName);
        if (this.parentTranslationKey.isEmpty()) {
            return buildingComponent;
        }
        MutableComponent parentComponent = customParentName.isEmpty() ? Component.m_237115_((String)this.parentTranslationKey) : Component.m_237113_((String)customParentName);
        return Component.m_237110_((String)"%s / %s", (Object[])new Object[]{parentComponent, buildingComponent});
    }

    @Override
    public boolean canBuild(IBuilding building) {
        return building instanceof BuildingBuilder && this.canBuildIgnoringDistance(building, building.getPosition(), building.getBuildingLevel()) && building.getPosition().m_123331_((Vec3i)this.getLocation()) <= 10000.0;
    }

    @Override
    public boolean canBuildIgnoringDistance(@NotNull IBuilding building, @NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.getTargetLevel() || builderLevel == 5 || builderLocation.equals((Object)this.getLocation());
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().noneMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getPosition().m_123331_((Vec3i)this.getLocation()) <= 10000.0);
    }

    @Override
    public boolean isValid(@NotNull IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.getLocation()) != null;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.customName = compound.m_128461_(TAG_CUSTOM_NAME);
        this.customParentName = compound.m_128461_(TAG_CUSTOM_PARENT_NAME);
        this.parentTranslationKey = compound.m_128461_(TAG_PARENT_TRANSLATION_KEY);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        compound.m_128359_(TAG_CUSTOM_NAME, this.customName);
        compound.m_128359_(TAG_CUSTOM_PARENT_NAME, this.customParentName);
        compound.m_128359_(TAG_PARENT_TRANSLATION_KEY, this.parentTranslationKey);
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        super.serializeViewNetworkData(buf);
        buf.m_130070_(this.customName);
        buf.m_130070_(this.customParentName);
        buf.m_130070_(this.parentTranslationKey);
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
        IBuilding building;
        super.onCompleted(colony, citizen);
        if (this.getWorkOrderType() != WorkOrderType.REMOVE && (building = colony.getBuildingManager().getBuilding(this.getLocation())) != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayer)player, building.getBuildingType().getRegistryName().m_135815_(), this.getTargetLevel()));
        }
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        IBuilding building;
        if (!readingFromNbt && colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getCorners(), colony);
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.getLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }
}

