/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.PlaceStructureOperation;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.managers.EventManager;
import com.minecolonies.core.util.CreativeRaiderStructureHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.NotNull;

public class EventStructureManager
implements IEventStructureManager {
    private static final String TAG_EVENT_STRUCTURE_MANAGER = "eventstructure_manager";
    public static final String STRUCTURE_BACKUP_FOLDER = "structbackup";
    private final Map<BlockPos, Integer> backupSchematics = new HashMap<BlockPos, Integer>();
    private final EventManager eventManager;
    private final IColony colony;

    public EventStructureManager(EventManager eventManager, IColony colony) {
        this.eventManager = eventManager;
        this.colony = colony;
    }

    @Override
    public boolean spawnTemporaryStructure(Blueprint structure, BlockPos targetSpawnPoint, int eventID) {
        if (this.eventManager.getEventByID(eventID) == null) {
            return false;
        }
        Level world = this.colony.getWorld();
        int y = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)structure, (int)4) - 1;
        BlockPos spawnPos = targetSpawnPoint.m_6625_(y).m_6630_(structure.getPrimaryBlockOffset().m_123342_());
        BlockPos zeroPos = spawnPos.m_121996_((Vec3i)structure.getPrimaryBlockOffset());
        BlockPos anchor = new BlockPos(zeroPos.m_123341_() + structure.getSizeX() / 2, zeroPos.m_123342_(), zeroPos.m_123343_() + structure.getSizeZ() / 2);
        Path outputPath = new File(".").toPath().resolve("blueprints").resolve(STRUCTURE_BACKUP_FOLDER).resolve(Integer.toString(this.colony.getID())).resolve(this.colony.getDimension().m_135782_().m_135827_() + this.colony.getDimension().m_135782_().m_135815_()).resolve(anchor.toString() + ".blueprint");
        CompoundTag bp = BlueprintUtil.writeBlueprintToNBT((Blueprint)BlueprintUtil.createBlueprint((Level)world, (BlockPos)zeroPos, (boolean)true, (short)structure.getSizeX(), (short)structure.getSizeY(), (short)structure.getSizeZ(), (String)anchor.toString(), Optional.of(anchor)));
        StructurePacks.storeBlueprint((String)STRUCTURE_BACKUP_FOLDER, (CompoundTag)bp, (Path)outputPath);
        this.backupSchematics.put(anchor, eventID);
        CreativeRaiderStructureHandler.loadAndPlaceStructure(world, structure, spawnPos, true, this.colony.getID(), (IColonyRaidEvent)this.eventManager.getEventByID(eventID), null);
        return true;
    }

    @Override
    public void loadBackupForEvent(int eventID) {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.backupSchematics.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() != eventID) continue;
            Path backupPath = new File(".").toPath().resolve("blueprints").resolve(STRUCTURE_BACKUP_FOLDER).resolve(Integer.toString(this.colony.getID())).resolve(this.colony.getDimension().m_135782_().m_135827_() + this.colony.getDimension().m_135782_().m_135815_()).resolve(entry.getKey().toString() + ".blueprint");
            ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)STRUCTURE_BACKUP_FOLDER, (Path)backupPath), this.colony.getWorld(), blueprint -> {
                if (blueprint == null) {
                    Log.getLogger().info("Minor issue: Failed to restore backup" + backupPath.toString());
                    return;
                }
                CreativeStructureHandler structure = new CreativeStructureHandler(this.colony.getWorld(), (BlockPos)entry.getKey(), blueprint, new PlacementSettings(Mirror.NONE, Rotation.NONE), true);
                Manager.addToQueue((ITickedWorldOperation)new PlaceStructureOperation(new StructurePlacer((IStructureHandler)structure), null));
                try {
                    Files.delete(backupPath);
                }
                catch (Exception e) {
                    Log.getLogger().info("Minor issue: Failed at deleting a backup schematic at " + backupPath.toString(), (Throwable)e);
                }
            }));
            iterator.remove();
        }
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        if (compound.m_128441_(TAG_EVENT_STRUCTURE_MANAGER)) {
            this.backupSchematics.clear();
            CompoundTag structureManagerCompound = compound.m_128469_(TAG_EVENT_STRUCTURE_MANAGER);
            ListTag schematicTags = structureManagerCompound.m_128437_("ships", 10);
            for (Tag base : schematicTags) {
                CompoundTag tagCompound = (CompoundTag)base;
                BlockPos pos = BlockPosUtil.read(tagCompound, "pos");
                int eventID = tagCompound.m_128451_("mc_event_id");
                if (this.eventManager.getEventByID(eventID) != null) {
                    this.backupSchematics.put(pos, eventID);
                    continue;
                }
                this.loadBackupForEvent(eventID);
                Log.getLogger().debug("Discarding schematic backup for event id:" + eventID + " seems the event went missing.");
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        CompoundTag structureManagerCompound = new CompoundTag();
        @NotNull ListTag schematicTagList = new ListTag();
        for (Map.Entry<BlockPos, Integer> entry : this.backupSchematics.entrySet()) {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.m_128405_("mc_event_id", entry.getValue().intValue());
            BlockPosUtil.write(entryCompound, "pos", entry.getKey());
            schematicTagList.add((Object)entryCompound);
        }
        structureManagerCompound.m_128365_("ships", (Tag)schematicTagList);
        compound.m_128365_(TAG_EVENT_STRUCTURE_MANAGER, (Tag)structureManagerCompound);
    }
}

