/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs.registry;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.Log;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JobDataManager
implements IJobDataManager {
    @Override
    @Nullable
    public IJob<?> createFrom(ICitizenData citizen, @NotNull CompoundTag compound) {
        ResourceLocation jobType;
        String jobTypeName = compound.m_128461_("type");
        ResourceLocation resourceLocation = jobType = compound.m_128441_("type") ? new ResourceLocation(jobTypeName) : ModJobs.PLACEHOLDER_ID;
        if (jobType == null) {
            Log.getLogger().error(String.format("Unknown job type '%s'.", jobTypeName), (Throwable)new Exception());
            return null;
        }
        JobEntry jobEntry = (JobEntry)IJobRegistry.getInstance().getValue(jobType);
        if (jobEntry == null) {
            Log.getLogger().error(String.format("Unknown job entry for type '%s'.", jobTypeName), (Throwable)new Exception());
            return null;
        }
        IJob job = Optional.ofNullable(jobEntry).map(r -> r.produceJob(citizen)).orElse(null);
        if (job != null) {
            try {
                job.deserializeNBT((Tag)compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", jobType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", jobType));
        }
        return job;
    }

    @Override
    public IJobView createViewFrom(IColonyView colony, ICitizenDataView citizenDataView, FriendlyByteBuf networkBuffer) {
        ResourceLocation jobName = new ResourceLocation(networkBuffer.m_130136_(Short.MAX_VALUE));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(jobName);
        if (entry == null) {
            Log.getLogger().error(String.format("Unknown job type '%s'.", jobName), (Throwable)new Exception());
            return null;
        }
        IJobView view = entry.getJobViewProducer().get().apply(colony, citizenDataView);
        if (view != null) {
            view.deserialize(networkBuffer);
        }
        return view;
    }
}

