/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractAISkeleton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure<AI extends AbstractAISkeleton<J>, J extends AbstractJobStructure<AI, J>>
extends AbstractJob<AI, J> {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        if (this.workOrderId == 0 || this.getWorkOrder() == null) {
            this.workOrderId = 0;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.workOrderId != 0) {
            compound.m_128405_(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_(TAG_WORK_ORDER)) {
            this.workOrderId = compound.m_128451_(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony(), this.getCitizen());
        Blueprint blueprint = this.getWorkOrder().getBlueprint();
        if (blueprint != null) {
            CompoundTag[][][] tileEntityData = blueprint.getTileEntities();
            for (short x = 0; x < blueprint.getSizeX(); x = (short)(x + 1)) {
                for (short y = 0; y < blueprint.getSizeY(); y = (short)(y + 1)) {
                    for (short z = 0; z < blueprint.getSizeZ(); z = (short)(z + 1)) {
                        CompoundTag compoundNBT = tileEntityData[y][z][x];
                        if (compoundNBT == null || !compoundNBT.m_128441_("blueprintDataProvider")) continue;
                        BlockPos offset = new BlockPos((int)x, (int)y, (int)z);
                        BlockPos tePos = this.getWorkOrder().getLocation().m_121996_((Vec3i)blueprint.getPrimaryBlockOffset()).m_121955_((Vec3i)offset);
                        BlockEntity te = this.getColony().getWorld().m_7702_(tePos);
                        if (!(te instanceof IBlueprintDataProviderBE)) continue;
                        IBlueprintDataProviderBE blueprintDataProviderBE = (IBlueprintDataProviderBE)te;
                        CompoundTag tagData = compoundNBT.m_128469_("blueprintDataProvider");
                        tagData.m_128359_("pack", blueprint.getPackName());
                        if (blueprint.getPrimaryBlockOffset().equals((Object)offset)) {
                            tagData.m_128359_("path", StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(Utils.resolvePath(blueprint.getFilePath(), tagData.m_128461_("schematicName"))) + ".blueprint");
                        }
                        try {
                            blueprintDataProviderBE.readSchematicDataFromNBT(compoundNBT);
                        }
                        catch (Exception e) {
                            Log.getLogger().warn("Broken deco-controller at: {}", (Object)offset);
                        }
                        ((ServerLevel)this.getColony().getWorld()).m_7726_().m_8450_(tePos);
                        te.m_6596_();
                    }
                }
            }
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
    }

    public IBuilderWorkOrder getWorkOrder() {
        @Nullable IBuilderWorkOrder workOrder = this.getColony().getWorkManager().getWorkOrder(this.workOrderId, IBuilderWorkOrder.class);
        if (workOrder == null) {
            return null;
        }
        if (!workOrder.getClaimedBy().equals((Object)this.getCitizen().getWorkBuilding().getID())) {
            this.workOrderId = 0;
            return null;
        }
        return workOrder;
    }

    private void resetNeededItems() {
        IBuilding workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof AbstractBuildingStructureBuilder) {
            ((AbstractBuildingStructureBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable IWorkOrder order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

