/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SimpleNotificationInteraction
extends StandardInteraction {
    private boolean active = true;

    public SimpleNotificationInteraction(Component inquiry, IChatPriority priority) {
        super(inquiry, null, priority);
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        super.onServerResponseTriggered(responseId, player, data);
        this.onResponse(responseId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        this.onResponse(responseId);
        return super.onClientResponseTriggered(responseId, player, data, window);
    }

    private void onResponse(int responseId) {
        Component response = this.getPossibleResponses().get(responseId);
        if (response.m_214077_() instanceof TranslatableContents && (((TranslatableContents)response.m_214077_()).m_237508_().equals("com.minecolonies.coremod.gui.chat.okay") || ((TranslatableContents)response.m_214077_()).m_237508_().equals("com.minecolonies.coremod.gui.chat.ignore"))) {
            this.active = false;
        }
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.SIMPLE_NOTIFICATION.m_135815_();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.active;
    }
}

