/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic.UpwardsGrowingPlantModule;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class KelpPlantModule
extends UpwardsGrowingPlantModule {
    private static final int MIN_HEIGHT = 2;
    private static final int MAX_HEIGHT = 25;

    public KelpPlantModule(IBuildingExtension field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    protected boolean isValidPlantingBlock(BlockState blockState) {
        return blockState.m_60734_() == Blocks.f_49990_;
    }

    @Override
    protected boolean isValidHarvestBlock(BlockState blockState) {
        return blockState.m_60734_() == Blocks.f_50575_ || blockState.m_60734_() == Blocks.f_50576_;
    }

    @Override
    protected int getMinimumPlantLength() {
        return 2;
    }

    @Override
    @NotNull
    protected Integer getMaximumPlantLength() {
        return 25;
    }

    @Override
    public BlockPos getPositionToWalkTo(Level world, BlockPos workingPosition) {
        for (int i = 0; i < this.getMaximumPlantLength() + 1; ++i) {
            if (!world.m_8055_(workingPosition.m_6630_(i)).m_60795_()) continue;
            return workingPosition.m_6630_(i);
        }
        return workingPosition;
    }

    @Override
    public ResourceLocation getRequiredResearchEffect() {
        return ResearchConstants.PLANTATION_SEA;
    }

    @Override
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }
}

