/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.EnchanterStationModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.enchanter.EnchanterWorkerSetMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EnchanterStationsModuleView
extends AbstractBuildingModuleView {
    private List<BlockPos> buildingToGatherFrom = new ArrayList<BlockPos>();

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.buildingToGatherFrom.clear();
        for (int i = 0; i < size; ++i) {
            this.buildingToGatherFrom.add(buf.m_130135_());
        }
    }

    public List<BlockPos> getBuildingsToGatherFrom() {
        return this.buildingToGatherFrom;
    }

    public void addWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.add(blockPos);
        Network.getNetwork().sendToServer(new EnchanterWorkerSetMessage(this.buildingView, blockPos, true));
    }

    public void removeWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.remove(blockPos);
        Network.getNetwork().sendToServer(new EnchanterWorkerSetMessage(this.buildingView, blockPos, false));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new EnchanterStationModuleWindow(this.buildingView, this);
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/entity.png");
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.gui.workerhuts.enchanter.workers";
    }
}

