/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.core.colony.buildings.modules.expedition.ExpeditionLog;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpeditionLogModule
extends AbstractBuildingModule
implements IPersistentModule {
    private static final String TAG_LOG = "expedition";
    @NotNull
    private final ExpeditionLog log = new ExpeditionLog();
    @Nullable
    private final ResourceLocation research;

    public ExpeditionLogModule(@Nullable ResourceLocation research) {
        this.research = research;
    }

    @NotNull
    public ExpeditionLog getLog() {
        return this.log;
    }

    @Override
    public void serializeNBT(@NotNull CompoundTag compound) {
        this.log.serializeNBT(compound);
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compound) {
        CompoundTag log = compound.m_128441_(TAG_LOG) ? compound.m_128469_(TAG_LOG) : compound;
        this.log.deserializeNBT(log);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        boolean unlocked = this.research == null || this.getBuilding().getColony().getResearchManager().getResearchEffects().getEffectStrength(this.research) > 0.0;
        buf.writeBoolean(unlocked);
        if (unlocked) {
            this.log.serialize(buf);
        }
    }
}

