/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.event.ClientEventHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CitizenArmorLayer<T extends AbstractEntityCitizen, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final Map<UUID, GameProfile> gameProfileMap = new HashMap<UUID, GameProfile>();
    private static Set<Item> disabledFromRendering = new HashSet<Item>();

    public CitizenArmorLayer(RenderLayerParent<T, M> parentLayer, A innerModel, A outerModel, ModelManager modelManager, EntityModelSet modelSet) {
        super(parentLayer, innerModel, outerModel, modelManager);
        this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)modelSet);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull T citizen, float ignore_1, float ignore_2, float partialTicks, float ignore_4, float headRotY, float headRotX) {
        if (((AbstractEntityCitizen)citizen).getCitizenDataView() == null) {
            return;
        }
        if (((AbstractEntityCitizen)citizen).getCitizenDataView().getInventory() == null) {
            return;
        }
        if (citizen.m_20145_()) {
            return;
        }
        ICitizenDataView citizenDataView = ((AbstractEntityCitizen)citizen).getCitizenDataView();
        if (citizenDataView.getCustomTextureUUID() != null) {
            UUID textureUUID = citizenDataView.getCustomTextureUUID();
            GameProfile gameProfile = this.gameProfileMap.get(textureUUID);
            if (gameProfile != null) {
                poseStack.m_85836_();
                poseStack.m_85841_(1.0f, -1.0f, -1.0f);
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128362_("Id", citizenDataView.getCustomTextureUUID());
                SkullBlock.Types type = SkullBlock.Types.PLAYER;
                SkullModelBase skullmodelbase = this.skullModels.get(type);
                RenderType rendertype = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)gameProfile);
                poseStack.m_272245_(Axis.f_252436_.m_252977_(180.0f), 0.0f, 0.0f, 0.0f);
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                VertexConsumer vertexconsumer = bufferSource.m_6299_(rendertype);
                skullmodelbase.m_6251_(0.0f, headRotY, headRotX);
                skullmodelbase.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            } else {
                this.gameProfileMap.put(citizenDataView.getCustomTextureUUID(), new GameProfile(textureUUID, "mcoltexturequery"));
                Util.m_183991_().execute(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    GameProfile profile = new GameProfile(textureUUID, "mcoltexturequery");
                    minecraft.m_91108_().fillProfileProperties(profile, true);
                    minecraft.m_18691_(() -> this.gameProfileMap.put(textureUUID, profile));
                });
            }
        }
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.CHEST, light, this.m_117078_(EquipmentSlot.CHEST), citizenDataView);
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.LEGS, light, this.m_117078_(EquipmentSlot.LEGS), citizenDataView);
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.FEET, light, this.m_117078_(EquipmentSlot.FEET), citizenDataView);
        this.renderArmorPiece(poseStack, bufferSource, citizen, EquipmentSlot.HEAD, light, this.m_117078_(EquipmentSlot.HEAD), citizenDataView);
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T citizen, EquipmentSlot equipmentSlot, int light, A armor, ICitizenDataView citizenDataView) {
        Item armorItem;
        ItemStack itemstack = citizenDataView.getDisplayArmor(equipmentSlot);
        if (itemstack.m_41619_()) {
            itemstack = citizen.m_6844_(equipmentSlot);
        }
        if ((armorItem = itemstack.m_41720_()) instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)armorItem;
            if (!disabledFromRendering.contains(armorItem)) {
                try {
                    if (armoritem.m_40402_() == equipmentSlot) {
                        ((HumanoidModel)this.m_117386_()).m_102872_(armor);
                        this.m_117125_((HumanoidModel)armor, equipmentSlot);
                        Model model = this.getArmorModelHook((LivingEntity)citizen, itemstack, equipmentSlot, (HumanoidModel)armor);
                        boolean flag = this.m_117128_(equipmentSlot);
                        if (armoritem instanceof DyeableLeatherItem) {
                            int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                            float f = (float)(i >> 16 & 0xFF) / 255.0f;
                            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                            float f2 = (float)(i & 0xFF) / 255.0f;
                            this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, null));
                            this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, "overlay"));
                        } else {
                            this.renderModel(poseStack, bufferSource, light, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)citizen, itemstack, equipmentSlot, null));
                        }
                        ArmorTrim.m_266285_((RegistryAccess)citizen.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(p_289638_ -> this.renderTrim(armoritem.m_40401_(), poseStack, bufferSource, light, (ArmorTrim)p_289638_, model, flag));
                        if (itemstack.m_41790_()) {
                            this.renderGlint(poseStack, bufferSource, light, model);
                        }
                    }
                }
                catch (Exception e) {
                    Log.getLogger().warn("Error rendering armor: " + String.valueOf(itemstack) + " report to the armor's mod.", (Throwable)e);
                    disabledFromRendering.add(armorItem);
                    ClientEventHandler.extraItemTooltips.put(armorItem, (Component)Component.m_237113_((String)"This armor is causing errors when rendering on citizens, check your latest.log and report to the respective armor mod.").m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorItem armorItem, Model model, boolean ignore, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource bufferSource, int light, Model model) {
        model.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTrim(ArmorMaterial armorMaterial, PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorTrim armorItem, Model model, boolean inner) {
        TextureAtlasSprite textureatlassprite = this.f_266073_.m_118316_(inner ? armorItem.m_267774_(armorMaterial) : armorItem.m_267606_(armorMaterial));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(bufferSource.m_6299_(Sheets.m_266442_()));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

