/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import com.minecolonies.core.network.messages.server.colony.building.GiveToolMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WindowPermissionsPage
extends AbstractWindowTownHall {
    @NotNull
    private final List<ColonyPlayer> users = new ArrayList<ColonyPlayer>();
    private ScrollingList userList;
    private ScrollingList actionsList;
    private ScrollingList freeBlocksList;
    private final ScrollingList rankButtonList;
    private final List<Rank> rankList = new LinkedList<Rank>();
    private final List<Rank> allRankList = new LinkedList<Rank>();
    private Rank actionsRank;
    private List<Action> actions = new ArrayList<Action>();
    private Map<Integer, String> rankTypes = new HashMap<Integer, String>();
    private ScrollingList eventList;

    public WindowPermissionsPage(BuildingTownHall.View building) {
        super(building, "layoutpermissions.xml");
        this.actions.addAll(Arrays.asList(Action.values()));
        this.rankTypes.put(0, "com.minecolonies.coremod.gui.townhall.ranktype.colonymanager");
        this.rankTypes.put(1, "com.minecolonies.coremod.gui.townhall.ranktype.hostile");
        this.rankTypes.put(2, "com.minecolonies.coremod.gui.townhall.ranktype.none");
        this.actionsRank = building.getColony().getPermissions().getRankOfficer();
        ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(false);
        this.rankButtonList = (ScrollingList)this.findPaneOfTypeByID("rankButtonList", ScrollingList.class);
        this.actionsList = (ScrollingList)this.findPaneOfTypeByID("rankList", ScrollingList.class);
        this.updateUsers();
        this.registerButton("addPlayer", this::addPlayerCLicked);
        this.registerButton("removePlayer", this::removePlayerClicked);
        this.registerButton("trigger", this::trigger);
        this.registerButton("addBlock", this::addBlock);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("blockTool", this::giveBlockTool);
        this.registerButton("buttonAddRank", this::addRank);
        this.registerButton("rankButton", this::onRankButtonClicked);
        this.registerButton("removeRank", this::onRemoveRankButtonClicked);
        this.registerButton("setSubscriber", this::setSubscriber);
        this.registerButton("addfakeplayer", this::addPlayerToColonyClicked);
        this.fillEventsList();
    }

    private void addPlayerToColonyClicked(@NotNull Button button) {
        int row = this.eventList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < ((ITownHallView)this.building).getPermissionEvents().size()) {
            PermissionEvent user = ((ITownHallView)this.building).getPermissionEvents().get(row);
            Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayerOrFakePlayer(((ITownHallView)this.building).getColony(), user.getName(), user.getId()));
        }
    }

    private void setSubscriber(Button button) {
        Network.getNetwork().sendToServer(new PermissionsMessage.SetSubscriber(((ITownHallView)this.building).getColony(), this.actionsRank, !this.actionsRank.isSubscriber()));
        this.actionsRank.setSubscriber(!this.actionsRank.isSubscriber());
        button.setText(Component.m_237115_((String)(this.actionsRank.isSubscriber() ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff")));
    }

    private void changeRankMode(DropDownList dropdown) {
        Network.getNetwork().sendToServer(new PermissionsMessage.EditRankType(((ITownHallView)this.building).getColony(), this.actionsRank, dropdown.getSelectedIndex()));
    }

    private void addRank() {
        TextField input = (TextField)this.findPaneOfTypeByID("addRankName", TextField.class);
        if (this.isValidRankname(input.getText())) {
            Network.getNetwork().sendToServer(new PermissionsMessage.AddRank(((ITownHallView)this.building).getColony(), input.getText()));
            input.setText("");
            SoundUtils.playSuccessSound((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_());
        } else {
            SoundUtils.playErrorSound((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_());
        }
    }

    private boolean isValidRankname(String name) {
        if (name.equals("")) {
            return false;
        }
        for (Rank rank : this.rankList) {
            if (!rank.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private void onRemoveRankButtonClicked(Button button) {
        if (this.actionsRank != null) {
            Network.getNetwork().sendToServer(new PermissionsMessage.RemoveRank(((ITownHallView)this.building).getColony(), this.actionsRank));
            ((ITownHallView)this.building).getColony().getPermissions().removeRank(this.actionsRank);
            this.actionsRank = ((ITownHallView)this.building).getColony().getPermissions().getRankOfficer();
            button.setEnabled(false);
        }
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(((ITownHallView)this.building).getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(ColonyPlayer::getRank, Rank::compareTo));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillUserList();
        this.fillFreeBlockList();
        this.fillRanks();
        this.fillPermissionList();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Button addPlayerButton = (Button)this.findPaneOfTypeByID("addPlayer", Button.class);
        TextField playerNameField = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        TextField rankNameField = (TextField)this.findPaneOfTypeByID("addRankName", TextField.class);
        Button addRankButton = (Button)this.findPaneOfTypeByID("buttonAddRank", Button.class);
        Button addBlockButton = (Button)this.findPaneOfTypeByID("addBlock", Button.class);
        Button blockToolButton = (Button)this.findPaneOfTypeByID("blockTool", Button.class);
        if (((ITownHallView)this.building).getColony().getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS)) {
            addPlayerButton.setEnabled(true);
            playerNameField.setEnabled(true);
            rankNameField.setEnabled(true);
            addRankButton.setEnabled(true);
            addBlockButton.setEnabled(true);
            blockToolButton.setEnabled(true);
        } else {
            AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane((Pane)playerNameField);
            ((AbstractTextBuilder.TooltipBuilder)hoverText.append(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.player_permission_error"))).paragraphBreak();
            hoverText.build();
            AbstractTextBuilder.TooltipBuilder hoverText2 = PaneBuilders.tooltipBuilder().hoverPane((Pane)rankNameField);
            ((AbstractTextBuilder.TooltipBuilder)hoverText2.append(Component.m_237115_((String)"com.minecolonies.core.gui.townhall.rank_permission_error"))).paragraphBreak();
            hoverText2.build();
            rankNameField.setEnabled(false);
            addPlayerButton.setEnabled(false);
            playerNameField.setEnabled(false);
            addRankButton.setEnabled(false);
            addBlockButton.setEnabled(false);
            blockToolButton.setEnabled(false);
        }
        ((DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class)).setSelectedIndex(this.actionsRank.isColonyManager() ? 0 : (this.actionsRank.isHostile() ? 1 : 2));
        ((Button)this.findPaneOfTypeByID("setSubscriber", Button.class)).setText(Component.m_237115_((String)(this.actionsRank.isSubscriber() ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff")));
    }

    private void updateRanks() {
        this.rankList.clear();
        for (Rank rank : ((ITownHallView)this.building).getColony().getPermissions().getRanks().values()) {
            if (rank.equals(((ITownHallView)this.building).getColony().getPermissions().getRankOwner())) continue;
            this.rankList.add(rank);
        }
        this.allRankList.clear();
        this.allRankList.addAll(((ITownHallView)this.building).getColony().getPermissions().getRanks().values());
    }

    private void fillRanks() {
        this.rankButtonList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.allRankList.size();
            }

            public void updateElement(int i, Pane pane) {
                Rank rank = WindowPermissionsPage.this.allRankList.get(i);
                Button button = (Button)pane.findPaneOfTypeByID("rankButton", Button.class);
                button.setText(Component.m_237113_((String)rank.getName()));
                button.setEnabled(!rank.equals(WindowPermissionsPage.this.actionsRank));
                ((Text)pane.findPaneOfTypeByID("rankId", Text.class)).setText(Component.m_237113_((String)Integer.toString(rank.getId())));
            }
        });
        DropDownList dropdown = (DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class);
        dropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.rankTypes.size();
            }

            public String getLabel(int i) {
                return Component.m_237115_((String)WindowPermissionsPage.this.rankTypes.get(i)).getString();
            }
        });
        dropdown.setHandler(this::changeRankMode);
    }

    private void onRankButtonClicked(@NotNull Button button) {
        int rankId = this.rankButtonList.getListElementIndexByPane((Pane)button);
        Rank rank = this.allRankList.get(rankId);
        if (rank != null) {
            this.actionsRank = rank;
            button.setEnabled(false);
            ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(!this.actionsRank.isInitial());
            ((DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class)).setSelectedIndex(this.actionsRank.isColonyManager() ? 0 : (this.actionsRank.isHostile() ? 1 : 2));
            ((Button)this.findPaneOfTypeByID("setSubscriber", Button.class)).setText(Component.m_237115_((String)(this.actionsRank.isSubscriber() ? "com.minecolonies.coremod.gui.workerhuts.retrieveon" : "com.minecolonies.coremod.gui.workerhuts.retrieveoff")));
        }
    }

    private void fillEventsList() {
        this.eventList = (ScrollingList)this.findPaneOfTypeByID("eventsList", ScrollingList.class);
        this.eventList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowPermissionsPage.this.building).getPermissionEvents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("name", Text.class);
                Text actionLabel = (Text)rowPane.findPaneOfTypeByID("action", Text.class);
                List<PermissionEvent> permissionEvents = ((ITownHallView)WindowPermissionsPage.this.building).getPermissionEvents();
                Collections.reverse(permissionEvents);
                PermissionEvent event = permissionEvents.get(index);
                nameLabel.setText(Component.m_237113_((String)(event.getName() + (event.getId() == null ? " <fake>" : ""))));
                ((Text)rowPane.findPaneOfTypeByID("pos", Text.class)).setText(Component.m_237113_((String)(event.getPosition().m_123341_() + " " + event.getPosition().m_123342_() + " " + event.getPosition().m_123343_())));
                ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).setVisible(event.getId() != null);
                actionLabel.setText(Component.m_237115_((String)("com.minecolonies.coremod.permission." + event.getAction().toString().toLowerCase(Locale.US))));
            }
        });
    }

    private void removeBlock(Button button) {
        int row = this.freeBlocksList.getListElementIndexByPane((Pane)button);
        if (row >= 0) {
            @NotNull List<Block> freeBlocks = ((ITownHallView)this.building).getColony().getFreeBlocks();
            @NotNull List<BlockPos> freePositions = ((ITownHallView)this.building).getColony().getFreePositions();
            if (row < freeBlocks.size()) {
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), freeBlocks.get(row), ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                ((ITownHallView)this.building).getColony().removeFreeBlock(freeBlocks.get(row));
            } else if (row < freeBlocks.size() + freePositions.size()) {
                BlockPos freePos = freePositions.get(row - freeBlocks.size());
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), freePos, ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                ((ITownHallView)this.building).getColony().removeFreePosition(freePos);
            }
            this.fillFreeBlockList();
        }
    }

    private void giveBlockTool(Button button) {
        Network.getNetwork().sendToServer(new GiveToolMessage(this.buildingView, ModItems.permTool));
    }

    private void fillFreeBlockList() {
        final @NotNull List<Block> freeBlocks = ((ITownHallView)this.building).getColony().getFreeBlocks();
        final @NotNull List<BlockPos> freePositions = ((ITownHallView)this.building).getColony().getFreePositions();
        this.freeBlocksList = (ScrollingList)this.findPaneOfTypeByID("blocks", ScrollingList.class);
        this.freeBlocksList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return freeBlocks.size() + freePositions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index < freeBlocks.size()) {
                    Block block = (Block)freeBlocks.get(index);
                    MutableComponent text = Component.m_237113_((String)ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                    text.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)block.m_49954_().m_130940_(ChatFormatting.DARK_GRAY));
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(text);
                } else {
                    BlockPos pos = (BlockPos)freePositions.get(index - freeBlocks.size());
                    MutableComponent text = Component.m_237113_((String)(pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_()));
                    if (((ITownHallView)WindowPermissionsPage.this.building).getColony().getWorld().m_46749_(pos)) {
                        BlockState state = ((ITownHallView)WindowPermissionsPage.this.building).getColony().getWorld().m_8055_(pos);
                        text.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)state.m_60734_().m_49954_().m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(text);
                }
                boolean canEdit = ((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().hasPermission((Player)Minecraft.m_91087_().f_91074_, Action.EDIT_PERMISSIONS);
                ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).setEnabled(canEdit);
            }
        });
    }

    private void addBlock() {
        TextField input = (TextField)this.findPaneOfTypeByID("addBlockName", TextField.class);
        String inputText = input.getText();
        try {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputText));
            if (block != null && !block.m_49966_().m_60795_()) {
                ((ITownHallView)this.building).getColony().addFreeBlock(block);
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            }
        }
        catch (ResourceLocationException block) {
            // empty catch block
        }
        BlockPos pos = BlockPosUtil.getBlockPosOfString(inputText);
        if (pos != null) {
            Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(((ITownHallView)this.building).getColony(), pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            ((ITownHallView)this.building).getColony().addFreePosition(pos);
        }
        this.fillFreeBlockList();
        input.setText("");
    }

    private void trigger(@NotNull Button button) {
        String string;
        int index = this.actionsList.getListElementIndexByPane((Pane)button);
        Action action = this.actions.get(index);
        IPermissions permissions = ((ITownHallView)this.building).getColony().getPermissions();
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        ComponentContents componentContents = button.getText().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            string = contents.m_237508_();
        } else {
            string = button.getTextAsString();
        }
        String key = string;
        boolean enable = !"com.minecolonies.coremod.gui.workerhuts.retrieveon".equals(key);
        button.disable();
        if (!permissions.alterPermission(permissions.getRank((Player)playerEntity), this.actionsRank, action, enable)) {
            return;
        }
        Network.getNetwork().sendToServer(new PermissionsMessage.Permission(((ITownHallView)this.building).getColony(), enable, this.actionsRank, action));
        if (!enable) {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
        } else {
            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
        }
    }

    private void fillPermissionList() {
        this.actionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.actions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Action action = WindowPermissionsPage.this.actions.get(index);
                MutableComponent name = Component.m_237115_((String)("com.minecolonies.coremod.permission." + action.toString().toLowerCase(Locale.US)));
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((Component)name);
                boolean isTriggered = ((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().hasPermission(WindowPermissionsPage.this.actionsRank, action);
                Button onOffButton = (Button)rowPane.findPaneOfTypeByID("trigger", Button.class);
                onOffButton.setText(isTriggered ? Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon") : Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
                ((Text)rowPane.findPaneOfTypeByID("index", Text.class)).setText(Component.m_237113_((String)Integer.toString(index)));
                if (!((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().canAlterPermission(((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions().getRank((Player)Minecraft.m_91087_().f_91074_), WindowPermissionsPage.this.actionsRank, action)) {
                    onOffButton.disable();
                } else {
                    onOffButton.enable();
                }
            }
        });
    }

    private void fillUserList() {
        this.userList = (ScrollingList)this.findPaneOfTypeByID("users", ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.users.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyPlayer player = WindowPermissionsPage.this.users.get(index);
                Rank rank = player.getRank();
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)player.getName()));
                DropDownList dropdown = (DropDownList)rowPane.findPaneOfTypeByID("rankPicker", DropDownList.class);
                int n = rank.getId();
                ((ITownHallView)WindowPermissionsPage.this.building).getColony().getPermissions();
                if (n == 0) {
                    ((Button)rowPane.findPaneOfTypeByID("removePlayer", Button.class)).setEnabled(false);
                    ((Text)rowPane.findPaneOfTypeByID("rank", Text.class)).setText(Component.m_237113_((String)rank.getName()));
                    dropdown.setEnabled(false);
                } else {
                    dropdown.setDataProvider(new DropDownList.DataProvider(){

                        public int getElementCount() {
                            return WindowPermissionsPage.this.rankList.size();
                        }

                        public String getLabel(int i) {
                            Rank rank = WindowPermissionsPage.this.rankList.get(i);
                            return rank.getName();
                        }
                    });
                    dropdown.setSelectedIndex(WindowPermissionsPage.this.rankList.indexOf(rank));
                    dropdown.setHandler(WindowPermissionsPage.this::onRankSelected);
                }
            }
        });
    }

    private void onRankSelected(DropDownList dropdown) {
        int index = dropdown.getSelectedIndex();
        ColonyPlayer player = this.users.get(this.userList.getListElementIndexByPane((Pane)dropdown));
        Rank rank = this.rankList.get(index);
        if (rank != player.getRank()) {
            player.setRank(rank);
            Network.getNetwork().sendToServer(new PermissionsMessage.ChangePlayerRank(((ITownHallView)this.building).getColony(), player.getID(), rank));
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateUsers();
        this.updateRanks();
    }

    private void addPlayerCLicked() {
        TextField input = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayer(((ITownHallView)this.building).getColony(), input.getText()));
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        ColonyPlayer user;
        int row = this.userList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank().getId() != 0) {
            Network.getNetwork().sendToServer(new PermissionsMessage.RemovePlayer(((ITownHallView)this.building).getColony(), user.getID()));
        }
    }

    @Override
    protected String getWindowId() {
        return "permissions";
    }
}

