/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.blockui;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.controls.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RotatingItemIcon
extends ItemIcon {
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private int duration = 2000;
    private int itemIndex = 0;
    private long lastUpdateMillis = System.currentTimeMillis();

    public void setItems(@NotNull List<ItemStack> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Items list must contain at least one item.");
        }
        this.items = items;
        this.resetState();
    }

    public void setDuration(int duration) {
        if (duration < 1) {
            throw new IllegalArgumentException("Duration cannot be zero or negative.");
        }
        this.duration = duration;
        this.resetState();
    }

    public void drawSelf(BOGuiGraphics ms, double mx, double my) {
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - this.lastUpdateMillis >= (long)this.duration) {
            this.lastUpdateMillis = currentMillis;
            ++this.itemIndex;
            this.itemIndex %= this.items.size();
            this.updateItem();
        }
        super.drawSelf(ms, mx, my);
    }

    private void resetState() {
        this.itemIndex = 0;
        this.lastUpdateMillis = System.currentTimeMillis();
        this.updateItem();
    }

    private void updateItem() {
        ItemStack newItem = this.items.get(this.itemIndex);
        this.setItem(newItem);
    }
}

