/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ButtonVanilla;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowExtendedBuildTool;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.items.ItemScanAnalyzer;
import com.minecolonies.core.util.SchemAnalyzerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WindowSchematicAnalyzer
extends AbstractWindowSkeleton {
    private static final String ID = "minecolonies:gui/analyzer/windowanalyze.xml";
    private static final String BUTTON_SELECTION_LEFT = "selectleft";
    private static final String BUTTON_SELECTION_RIGHT = "selectright";
    private static final String BUTTON_SELECT_SCHEMATIC = "selectschematic";
    private static final String BUTTON_VIEW_CURRENT = "viewschem";
    private static final String BOX_RESULTS = "results";
    private static final String BOX_LEFT = "left";
    private static final String BOX_RIGHT = "right";
    private static final String LABEL_SCORE = "score";
    private static final String LABEL_BLOCK_COUNTS = "blockcounts";
    private static final String LABEL_SIZE = "size";
    private static final String LABEL_BUILDINGS = "buildings";
    private static final String BUTTON_SHOW_RES = "showresources";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String LIST_RES = "resources";
    private static final String LIST_ENTRY_ITEMICON = "resourceIcon";
    private static final String LIST_ENTRY_LABEL = "resourceName";
    private static final String LIST_ENTRY_COUNT = "resourceCount";
    public static Map<Blueprint, SchemAnalyzerUtil.SchematicAnalyzationResult> analyzationResults = new LinkedHashMap<Blueprint, SchemAnalyzerUtil.SchematicAnalyzationResult>();
    private static List<SchemAnalyzerUtil.SchematicAnalyzationResult> sortedAnalyzationResults = new ArrayList<SchemAnalyzerUtil.SchematicAnalyzationResult>();
    private static SchemAnalyzerUtil.SchematicAnalyzationResult selectedLeft = null;
    private static SchemAnalyzerUtil.SchematicAnalyzationResult selectedRight = null;

    public WindowSchematicAnalyzer() {
        super(ID);
        this.registerButton(BUTTON_CANCEL, b -> this.close());
        this.registerButton(BUTTON_SELECT_SCHEMATIC, b -> new WindowExtendedBuildTool(BlockPos.m_274446_((Position)Minecraft.m_91087_().f_91074_.m_20182_().m_82549_(Minecraft.m_91087_().f_91074_.m_20154_().m_82542_(10.0, 10.0, 10.0))), 1, (window, blueprint) -> {
            Minecraft.m_91087_().m_91152_((Screen)this.getScreen());
            SchemAnalyzerUtil.SchematicAnalyzationResult result = analyzationResults.computeIfAbsent((Blueprint)blueprint, SchemAnalyzerUtil::analyzeSchematic);
            this.sortAnalyzationResults();
            this.switchSelectionTo(this.getBoxForSide((Pane)b), result);
        }, a -> true).open());
        this.registerButton(BUTTON_SELECTION_LEFT, b -> this.switchSelection((Button)b, false));
        this.registerButton(BUTTON_SELECTION_RIGHT, b -> this.switchSelection((Button)b, true));
        this.registerButton(BUTTON_SHOW_RES, this::showResourcesFor);
        if (ItemScanAnalyzer.blueprint != null) {
            analyzationResults.keySet().removeIf(blueprint -> blueprint.getName().equals(ItemScanAnalyzer.TEMP_SCAN));
            analyzationResults.put(ItemScanAnalyzer.blueprint, SchemAnalyzerUtil.analyzeSchematic(ItemScanAnalyzer.blueprint));
        }
        this.sortAnalyzationResults();
        for (SchemAnalyzerUtil.SchematicAnalyzationResult sortedAnalyzationResult : sortedAnalyzationResults) {
            if (!sortedAnalyzationResult.blueprint.equals((Object)ItemScanAnalyzer.blueprint)) continue;
            selectedRight = sortedAnalyzationResult;
            ItemScanAnalyzer.blueprint = null;
            break;
        }
        selectedLeft = this.getPrevFor(this.getNextFor(selectedLeft));
        this.switchSelectionTo(this.getLeftSide(), selectedLeft);
        this.switchSelectionTo(this.getRightSide(), selectedRight);
    }

    private void showResourcesFor(Button b) {
        ScrollingList resourceList = (ScrollingList)b.getParent().findPaneOfTypeByID(LIST_RES, ScrollingList.class);
        resourceList.setVisible(true);
        b.setVisible(false);
        SchemAnalyzerUtil.SchematicAnalyzationResult selected = this.getCurrentSelectionData((Pane)b);
        final ArrayList<ItemStorage> resources = new ArrayList<ItemStorage>(selected.differentBlocks);
        resources.sort(Comparator.comparingInt(itemStorage -> itemStorage.getAmount() * itemStorage.getItemStack().m_41613_()).reversed());
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return resources.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStorage storage = (ItemStorage)resources.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID(WindowSchematicAnalyzer.LIST_ENTRY_LABEL, Text.class);
                Text countLabel = (Text)rowPane.findPaneOfTypeByID(WindowSchematicAnalyzer.LIST_ENTRY_COUNT, Text.class);
                countLabel.setText(Component.m_237113_((String)Integer.toString(storage.getAmount())).m_130940_(ChatFormatting.YELLOW));
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)countLabel).append(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.score", (Object[])new Object[]{storage.getItemStack().m_41613_(), storage.getItemStack().m_41613_() * storage.getAmount()}))).build();
                resourceLabel.setText(storage.getItemStack().m_41786_());
                ItemStack copy = storage.getItemStack().m_41777_();
                copy.m_41764_(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID(WindowSchematicAnalyzer.LIST_ENTRY_ITEMICON, ItemIcon.class)).setItem(copy);
            }
        });
    }

    private Box getLeftSide() {
        return (Box)this.findPaneOfTypeByID(BOX_LEFT, Box.class);
    }

    private Box getRightSide() {
        return (Box)this.findPaneOfTypeByID(BOX_RIGHT, Box.class);
    }

    private Box getBoxForSide(Pane context) {
        if (this.isLeft(context)) {
            return this.getLeftSide();
        }
        return this.getRightSide();
    }

    private boolean isLeft(Pane current) {
        if (current.getID().equals(BOX_LEFT)) {
            return true;
        }
        if (current.getParent() != null && current.getParent().getID().equals(BOX_LEFT)) {
            return true;
        }
        return current.getParent().getParent() != null && current.getParent().getParent().getID().equals(BOX_LEFT);
    }

    private SchemAnalyzerUtil.SchematicAnalyzationResult getCurrentSelectionData(Pane context) {
        SchemAnalyzerUtil.SchematicAnalyzationResult selection = this.isLeft(context) ? selectedLeft : selectedRight;
        return selection;
    }

    private SchemAnalyzerUtil.SchematicAnalyzationResult getNextFor(SchemAnalyzerUtil.SchematicAnalyzationResult current) {
        int currentIndex = sortedAnalyzationResults.indexOf(current);
        if (current != null && currentIndex == -1 && !sortedAnalyzationResults.isEmpty()) {
            return sortedAnalyzationResults.get(0);
        }
        if (currentIndex != -1 && currentIndex + 1 < sortedAnalyzationResults.size()) {
            return sortedAnalyzationResults.get(currentIndex + 1);
        }
        return current;
    }

    private SchemAnalyzerUtil.SchematicAnalyzationResult getPrevFor(SchemAnalyzerUtil.SchematicAnalyzationResult current) {
        int currentIndex = sortedAnalyzationResults.indexOf(current);
        if (current != null && currentIndex == -1 && !sortedAnalyzationResults.isEmpty()) {
            return sortedAnalyzationResults.get(0);
        }
        if (currentIndex - 1 >= 0 && currentIndex - 1 < sortedAnalyzationResults.size()) {
            return sortedAnalyzationResults.get(currentIndex - 1);
        }
        return current;
    }

    private void sortAnalyzationResults() {
        sortedAnalyzationResults = new ArrayList<SchemAnalyzerUtil.SchematicAnalyzationResult>(analyzationResults.values());
        sortedAnalyzationResults.sort((o1, o2) -> o1.blueprint.getName().compareToIgnoreCase(o2.blueprint.getName()));
    }

    private void switchSelection(Button buttonClicked, boolean next) {
        SchemAnalyzerUtil.SchematicAnalyzationResult result = next ? this.getNextFor(this.getCurrentSelectionData((Pane)buttonClicked)) : this.getPrevFor(this.getCurrentSelectionData((Pane)buttonClicked));
        this.switchSelectionTo(this.getBoxForSide((Pane)buttonClicked), result);
    }

    private void switchSelectionTo(Box parent, SchemAnalyzerUtil.SchematicAnalyzationResult next) {
        if (this.isLeft((Pane)parent)) {
            selectedLeft = next;
        } else {
            selectedRight = next;
        }
        Box box = (Box)parent.findPaneOfTypeByID(BOX_RESULTS, Box.class);
        if (box == null) {
            Log.getLogger().warn("Nonexisting pane");
            return;
        }
        if (next == null) {
            ((ButtonVanilla)parent.findPaneOfTypeByID(BUTTON_VIEW_CURRENT, ButtonVanilla.class)).setText(Component.m_237113_((String)"none"));
            box.hide();
            ((ButtonImage)box.findPaneOfTypeByID(BUTTON_SHOW_RES, ButtonImage.class)).setVisible(false);
            return;
        }
        box.show();
        Object name = next.blueprint.getName();
        if (next.blueprint.getFileName() != null && next.blueprint.getFilePath() != null) {
            String[] split = next.blueprint.getFileName().split("/");
            name = next.blueprint.getFilePath().toString().replace("blueprints/minecolonies/", "") + "/" + split[split.length - 1];
        }
        name = ((String)name).replace(".blueprint", "");
        ((ButtonVanilla)parent.findPaneOfTypeByID(BUTTON_VIEW_CURRENT, ButtonVanilla.class)).setText(Component.m_237113_((String)name));
        ((Text)box.findPaneOfTypeByID(LABEL_SCORE, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.complexity", (Object[])new Object[]{Component.m_237113_((String)("" + next.costScore)).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)}));
        ((Text)box.findPaneOfTypeByID(LABEL_BLOCK_COUNTS, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.blockcounts", (Object[])new Object[]{Component.m_237113_((String)("" + next.differentBlocks.size())).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.BOLD)}));
        ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.score", (Object[])new Object[]{next.differentBlocks.size() * 40, next.costScore}))).hoverPane(box.findPaneOfTypeByID(LABEL_BLOCK_COUNTS, Text.class)).build();
        ((Text)box.findPaneOfTypeByID(LABEL_SIZE, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.size", (Object[])new Object[]{Component.m_237113_((String)("[" + next.blueprint.getSizeX() + " " + next.blueprint.getSizeY() + " " + next.blueprint.getSizeZ() + "]")).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD)}));
        ((Text)box.findPaneOfTypeByID(LABEL_BUILDINGS, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.analyzer.buildings", (Object[])new Object[]{Component.m_237113_((String)("" + next.containedBuildings)).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD)}));
        ScrollingList resourceList = (ScrollingList)box.findPaneOfTypeByID(LIST_RES, ScrollingList.class);
        resourceList.setVisible(false);
        ((ButtonImage)box.findPaneOfTypeByID(BUTTON_SHOW_RES, ButtonImage.class)).setText(Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.showres"));
        ((ButtonImage)box.findPaneOfTypeByID(BUTTON_SHOW_RES, ButtonImage.class)).setVisible(true);
    }

    public void onClosed() {
        RenderingCache.removeBox((String)"analyzer");
        super.onClosed();
    }
}

