/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.server.ReactivateBuildingMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class WindowReactivateBuilding
extends AbstractWindowSkeleton {
    @NotNull
    private final BlockPos pos;

    public WindowReactivateBuilding(@NotNull BlockPos pos) {
        super("minecolonies:gui/windowreactivatebuilding.xml");
        this.pos = pos;
        this.registerButton("reactivate", this::reactivateClicked);
        this.registerButton("cancel", this::cancelClicked);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding tileEntityColonyBuilding = (TileEntityColonyBuilding)blockEntity;
            BuildingEntry buildingEntry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(tileEntityColonyBuilding.registryName);
            if (buildingEntry == ModBuildings.home.get() || buildingEntry == ModBuildings.tavern.get()) {
                ((Text)this.findPaneOfTypeByID("text", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.core.gui.reactivate.message.living", (Object[])new Object[]{Component.m_237115_((String)buildingEntry.getTranslationKey())}));
            } else if (buildingEntry != null) {
                ((Text)this.findPaneOfTypeByID("text", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.core.gui.reactivate.message.working", (Object[])new Object[]{Component.m_237115_((String)buildingEntry.getTranslationKey())}));
            }
        }
    }

    private void reactivateClicked() {
        Network.getNetwork().sendToServer(new ReactivateBuildingMessage(this.pos));
        this.close();
    }

    private void cancelClicked() {
        this.close();
    }
}

