/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowRequestTree;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowPostBox
extends AbstractWindowRequestTree {
    private static final String TAG_BUTTON_DELIVER_AVAILABLE = "deliverAvailable";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList stackList;
    private final AbstractBuildingView buildingView;
    private String filter = "";
    private boolean deliverAvailable;
    private int tick;

    public WindowPostBox(AbstractBuildingView buildingView) {
        super(buildingView.getID(), "minecolonies:gui/windowpostbox.xml", buildingView.getColony());
        this.buildingView = buildingView;
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("request", this::requestClicked);
        this.registerButton(TAG_BUTTON_DELIVER_AVAILABLE, this::deliverPartialClicked);
        ((TextField)this.window.findPaneOfTypeByID("name", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage(this.buildingView));
    }

    private void requestClicked(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStack stack = this.allItems.get(row);
        int qty = stack.m_41741_();
        for (Pane child : button.getParent().getChildren()) {
            if (!child.getID().equals("qty")) continue;
            try {
                qty = Integer.parseInt(((TextField)child).getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Network.getNetwork().sendToServer(new PostBoxRequestMessage(this.buildingView, stack.m_41777_(), qty, this.deliverAvailable));
    }

    private void deliverPartialClicked(@NotNull Button button) {
        if (button.getTextAsString().equals(RED_X)) {
            button.setText(Component.m_237113_((String)APPROVE));
            this.deliverAvailable = true;
        } else {
            button.setText(Component.m_237113_((String)RED_X));
            this.deliverAvailable = false;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_DELIVER_AVAILABLE, Button.class)).setText(Component.m_237113_((String)RED_X));
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.m_41786_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.m_41720_() instanceof EnchantedBookItem && EnchantedBookItem.m_41163_((ItemStack)stack).m_128728_(0).m_128461_("id").contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.m_41786_().getString(), (CharSequence)this.filter)));
        this.updateResourceList();
    }

    private Collection<? extends ItemStack> getBlockList(Predicate<ItemStack> filterPredicate) {
        Set<ItemStack> allItems = ItemStackUtils.allItemsPlusInventory((Player)Minecraft.m_91087_().f_91074_);
        if (this.filter.isEmpty()) {
            return allItems;
        }
        return allItems.stream().filter(filterPredicate).collect(Collectors.toList());
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.m_41786_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }
}

