/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesDirectional;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.core.client.gui.WindowDecorationController;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockDecorationController
extends AbstractBlockMinecoloniesDirectional<BlockDecorationController>
implements IBuilderUndestroyable,
IAnchorBlock,
EntityBlock,
ILeveledBlueprintAnchorBlock,
SimpleWaterloggedBlock {
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "decorationcontroller";
    private static final float RESISTANCE = 1.0f;
    public static BooleanProperty MIRROR = BooleanProperty.m_61465_((String)"mirror");
    protected static final VoxelShape AABB_SOUTH = Shapes.m_83048_((double)0.25, (double)0.314, (double)0.7, (double)0.75, (double)0.86, (double)1.0);
    protected static final VoxelShape AABB_NORTH = Shapes.m_83048_((double)0.25, (double)0.314, (double)0.0, (double)0.75, (double)0.86, (double)0.3);
    protected static final VoxelShape AABB_EAST = Shapes.m_83048_((double)0.7, (double)0.314, (double)0.25, (double)1.0, (double)0.86, (double)0.75);
    protected static final VoxelShape AABB_WEST = Shapes.m_83048_((double)0.0, (double)0.314, (double)0.25, (double)0.3, (double)0.86, (double)0.75);
    protected static final VoxelShape AABB_UP = Shapes.m_83048_((double)0.25, (double)0.7, (double)0.14, (double)0.75, (double)1.0, (double)0.686);
    protected static final VoxelShape AABB_DOWN = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.314, (double)0.75, (double)0.3, (double)0.86);

    public BlockDecorationController() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(5.0f, 1.0f).m_60910_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public VoxelShape m_5940_(BlockState decoController, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        Direction direction = (Direction)decoController.m_61143_((Property)f_52588_);
        BlockPos offsetPos = pos.m_121945_(direction);
        BlockState state = level.m_8055_(offsetPos);
        VoxelShape voxelShape = shape = state.m_60734_() != this ? state.m_60808_(level, offsetPos) : Shapes.m_83144_();
        if (shape.m_83281_() || Block.m_49916_((VoxelShape)shape)) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.EAST -> AABB_EAST;
                case Direction.WEST -> AABB_WEST;
                case Direction.SOUTH -> AABB_SOUTH;
                case Direction.NORTH -> AABB_NORTH;
                case Direction.UP -> AABB_UP;
                case Direction.DOWN -> AABB_DOWN;
            };
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> AABB_UP.m_83216_(0.0, shape.m_83288_(Direction.Axis.Y), 0.0);
            case Direction.DOWN -> AABB_DOWN.m_83216_(0.0, shape.m_83297_(Direction.Axis.Y) - 1.0, 0.0);
            case Direction.NORTH -> AABB_NORTH.m_83216_(0.0, 0.0, shape.m_83297_(Direction.Axis.Z) - 1.0);
            case Direction.SOUTH -> AABB_SOUTH.m_83216_(0.0, 0.0, shape.m_83288_(Direction.Axis.Z));
            case Direction.EAST -> AABB_EAST.m_83216_(shape.m_83288_(Direction.Axis.X), 0.0, 0.0);
            case Direction.WEST -> AABB_WEST.m_83216_(shape.m_83297_(Direction.Axis.X) - 1.0, 0.0, 0.0);
        };
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, Direction dir, BlockState state, LevelAccessor worldIn, @NotNull BlockPos currentPos, BlockPos pos) {
        if (((Boolean)stateIn.m_61143_((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, dir, state, worldIn, currentPos, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity;
        if (worldIn.f_46443_ && (tileEntity = worldIn.m_7702_(pos)) instanceof TileEntityDecorationController) {
            new WindowDecorationController(pos).open();
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        IColony colony;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileEntityDecorationController && ((List)((TileEntityDecorationController)tileEntity).getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList())).contains("leisure") && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null) {
            colony.getBuildingManager().addLeisureSite(pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, MIRROR, AbstractBlockMinecoloniesConstructionTape.WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityDecorationController(blockPos, blockState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Fluid fluid = context.m_43725_().m_6425_(context.m_8083_()).m_76152_();
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_52588_, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(mirrorIn != Mirror.NONE));
    }

    public int getLevel(CompoundTag beData) {
        if (beData == null) {
            return 0;
        }
        try {
            return Integer.parseInt(beData.m_128469_("blueprintDataProvider").m_128461_("schematicName").replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }
}

