/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.requestsystem.request.RequestUtils;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.QuarryModule;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingNetherWorker;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobBeekeeper;
import com.minecolonies.core.colony.jobs.JobDeliveryman;
import com.minecolonies.core.colony.jobs.JobFisherman;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.colony.jobs.JobQuarrier;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIBasic;
import com.minecolonies.core.util.WorkerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class InteractionValidatorInitializer {
    public static void init() {
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(BuildingModules.FURNACE) && citizen.getWorkBuilding().hasModule(BuildingModules.ITEMLIST_FUEL) && ((ItemListModule)citizen.getWorkBuilding().getModule(BuildingModules.ITEMLIST_FUEL)).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(BuildingModules.FURNACE) && ((FurnaceUserModule)citizen.getWorkBuilding().getModule(BuildingModules.FURNACE)).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.wrongfood"), citizen -> InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), ItemStackUtils.ISCOOKABLE) != -1 && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), stack -> FoodUtils.canEat(stack, citizen.getHomeBuilding(), citizen.getWorkBuilding())) == -1);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.betterfood"), citizen -> citizen.getSaturation() == 0.0 && !citizen.isChild() && citizen.needsBetterFood());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.betterfood.children"), citizen -> citizen.getSaturation() == 0.0 && citizen.isChild() && citizen.needsBetterFood());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.norestaurant"), citizen -> citizen.getColony() != null && citizen.getSaturation() <= 6.0 && citizen.getEntity().isPresent() && citizen.getColony().getBuildingManager().getBestBuilding(citizen.getEntity().get(), BuildingCook.class) == null && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), ItemStackUtils.ISFOOD) == -1);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.nohospital"), citizen -> citizen.getColony() != null && citizen.getEntity().isPresent() && citizen.getCitizenDiseaseHandler().isSick() && citizen.getColony().getBuildingManager().getBestBuilding(citizen.getEntity().get(), BuildingHospital.class) == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.waitingforcure"), citizen -> citizen.getColony() != null && citizen.getEntity().isPresent() && citizen.getCitizenDiseaseHandler().getDisease() != null);
        InteractionValidatorRegistry.registerPosBasedPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman.workerchestfull"), (citizen, pos) -> {
            IItemHandler inv;
            IBuilding building;
            IColony colony;
            if (citizen.getJob() instanceof JobDeliveryman && (colony = citizen.getColony()) != null && (building = colony.getBuildingManager().getBuilding((BlockPos)pos)) != null && (inv = (IItemHandler)building.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElse(null)) != null) {
                return InventoryUtils.openSlotCount(inv) <= 0L;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman.nowarehouse"), cit -> {
            if (cit.getJob() instanceof JobDeliveryman && cit.getWorkBuilding() != null) {
                return ((JobDeliveryman)cit.getJob()).findWareHouse() == null;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.farmer.nofreefields"), citizen -> citizen.getWorkBuilding() instanceof BuildingFarmer && ((BuildingFarmer.FarmerFieldsModule)citizen.getWorkBuilding().getModule(BuildingModules.FARMER_FIELDS)).hasNoExtensions());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.miner.invalidmineshaft"), citizen -> citizen.getWorkBuilding() instanceof BuildingMiner && citizen.getJob() instanceof JobMiner && (((BuildingMiner)citizen.getWorkBuilding()).getCobbleLocation() == null || ((BuildingMiner)citizen.getWorkBuilding()).getLadderLocation() == null));
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.worker.inventoryfullchestfull"), citizen -> citizen.getWorkBuilding() != null && InventoryUtils.isBuildingFull(citizen.getWorkBuilding()));
        InteractionValidatorRegistry.registerPosBasedPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.toolow"), (citizen, pos) -> {
            Level world;
            IColony colony;
            IBuilding workBuilding = citizen.getWorkBuilding();
            if (workBuilding != null && (colony = citizen.getColony()) != null && (world = colony.getWorld()) != null) {
                return workBuilding.getMaxEquipmentLevel() < WorkerUtil.getCorrectHarvestLevelForBlock(world.m_8055_(pos));
            }
            return false;
        });
        InteractionValidatorRegistry.registerTokenBasedPredicate((Component)Component.m_237115_((String)"com.minecolonies.requestsystem.playerresolver.normal"), (citizen, token) -> {
            IColony colony = citizen.getColony();
            if (colony != null) {
                return RequestUtils.requestChainNeedsPlayer(token, citizen.getColony().getRequestManager());
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.noore"), citizen -> {
            if (citizen.getWorkBuilding() instanceof BuildingSmeltery) {
                ImmutableList<ItemStorage> oreList = ((ItemListModule)((BuildingSmeltery)citizen.getWorkBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals("ores"))).getList();
                for (ItemStorage storage : IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres()) {
                    if (oreList.contains(storage)) continue;
                    return true;
                }
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.healer.fullinv"), citizen -> citizen.getEntity().isPresent() && citizen.getCitizenDiseaseHandler().isSick() && !citizen.getEntity().get().getInventoryCitizen().hasSpace());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.school.nocarpet"), citizen -> citizen.getEntity().isPresent() && citizen.isChild() && citizen.getWorkBuilding() instanceof BuildingSchool && ((BuildingSchool)citizen.getWorkBuilding()).getRandomPlaceToSit() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.fisherman.messagewatertoofar"), citizen -> citizen.getJob() instanceof JobFisherman && ((JobFisherman)citizen.getJob()).getPonds().isEmpty());
        InteractionValidatorRegistry.registerPosBasedPredicate((Component)Component.m_237115_((String)"entity.fisherman.messagesuboptimalpond"), (citizen, pos) -> citizen.getJob() instanceof JobFisherman && BlockPosUtil.getDistance(citizen.getEntity().get().m_20183_(), pos) <= 12.0);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofuel"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(BuildingModules.FURNACE) && citizen.getWorkBuilding().hasModule(BuildingModules.ITEMLIST_FUEL) && ((ItemListModule)citizen.getWorkBuilding().getModule(BuildingModules.ITEMLIST_FUEL)).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofood"), citizen -> {
            if (!(citizen.getWorkBuilding() instanceof BuildingCook)) {
                return false;
            }
            return ((RestaurantMenuModule)citizen.getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU)).getMenu().isEmpty();
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.netherminer.nofood"), citizen -> {
            if (!(citizen.getWorkBuilding() instanceof BuildingNetherWorker)) {
                return false;
            }
            return ((RestaurantMenuModule)citizen.getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU)).getMenu().isEmpty();
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.sifter.nomesh"), citizen -> {
            if (!(citizen.getWorkBuilding() instanceof BuildingSifter)) {
                return false;
            }
            return InventoryUtils.getItemCountInProvider((ICapabilityProvider)citizen.getWorkBuilding(), item -> item.m_204117_(ModTags.meshes)) <= 0 && InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), item -> item.m_204117_(ModTags.meshes)) <= 0;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.bakery.nofurnace"), citizen -> citizen.getWorkBuilding() instanceof BuildingBaker && ((FurnaceUserModule)citizen.getWorkBuilding().getModule(BuildingModules.FURNACE)).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.beekeeper.messagenohives"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && ((BuildingBeekeeper)citizen.getWorkBuilding()).getHives().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.beekeeper.messagenobees"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && citizen.getJob(JobBeekeeper.class).checkForBeeInteraction());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.enchanter.nodrainingsset"), citizen -> citizen.getWorkBuilding() instanceof BuildingEnchanter && ((BuildingEnchanter)citizen.getWorkBuilding()).getModule(BuildingModules.ENCHANTER_STATIONS).getBuildingsToGatherFrom().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.noplantground"), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ((BuildingFlorist)citizen.getWorkBuilding()).getPlantGround().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.noflowers"), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ItemStackUtils.isEmpty(((BuildingFlorist)citizen.getWorkBuilding()).getFlowerToGrow()));
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.florist.nocompost"), citizen -> {
            IBuilding buildingFlorist = citizen.getWorkBuilding();
            if (buildingFlorist instanceof BuildingFlorist && buildingFlorist.getColony().getWorld() != null) {
                return InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), ItemStackUtils.IS_COMPOST) == 0 && !WorkerUtil.isThereCompostedLand((BuildingFlorist)buildingFlorist, buildingFlorist.getColony().getWorld());
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"entity.miner.messagerequiresbetterhut"), citizen -> {
            AbstractBuilding buildingMiner = (AbstractBuilding)citizen.getWorkBuilding();
            if (buildingMiner instanceof BuildingMiner && citizen.getColony() != null && citizen.getColony().getWorld() != null && citizen.getJob() instanceof JobMiner) {
                return WorkerUtil.getLastLadder(((BuildingMiner)buildingMiner).getLadderLocation(), citizen.getColony().getWorld()) < ((BuildingMiner)buildingMiner).getDepthLimit(citizen.getColony().getWorld()) && ((BuildingMiner)buildingMiner).getModule(BuildingModules.MINER_LEVELS).getNumberOfLevels() == 0;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.worker.ai.exception"), citizen -> citizen.getJob() != null && ((AbstractEntityAIBasic)citizen.getJob().getWorkerAI()).getExceptionTimer() > 1);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.demands.homelessness"), citizen -> ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("homelessness")).getDays() > 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.homelessness"), citizen -> ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("homelessness")).getDays() > 7 && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("homelessness")).getDays() <= 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.demands.unemployment"), citizen -> ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("unemployment")).getDays() > 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.unemployment"), citizen -> ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("unemployment")).getDays() > 7 && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("unemployment")).getDays() <= 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.demands.idleatjob"), citizen -> citizen.getJob() != null && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("idleatjob")).getDays() > citizen.getJob().getIdleSeverity(true));
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.idleatjob"), citizen -> citizen.getJob() != null && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("idleatjob")).getDays() > citizen.getJob().getIdleSeverity(false) && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("idleatjob")).getDays() <= citizen.getJob().getIdleSeverity(true));
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.slepttonight"), citizen -> !(citizen.getJob() instanceof AbstractJobGuard) && ((ITimeBasedHappinessModifier)citizen.getCitizenHappinessHandler().getModifier("slepttonight")).getDays() <= 0);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.foodquality.urgent"), citizen -> {
            if (citizen.getHomeBuilding() == null || !citizen.getCitizenFoodHandler().hasFullFoodHistory()) {
                return false;
            }
            int homeBuildingLevel = citizen.getHomeBuilding().getBuildingLevelEquivalent();
            if (homeBuildingLevel <= 2) {
                return false;
            }
            return citizen.getCitizenFoodHandler().getFoodHappinessStats().quality() < homeBuildingLevel - 2 - 1;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.fooddiversity.urgent"), citizen -> {
            if (citizen.getHomeBuilding() == null || !citizen.getCitizenFoodHandler().hasFullFoodHistory()) {
                return false;
            }
            int homeBuildingLevel = citizen.getHomeBuilding().getBuildingLevelEquivalent();
            if (homeBuildingLevel <= 1) {
                return false;
            }
            return (double)citizen.getCitizenFoodHandler().getFoodHappinessStats().diversity() < (double)homeBuildingLevel / 2.0;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.foodquality"), citizen -> {
            if (citizen.getHomeBuilding() == null || !citizen.getCitizenFoodHandler().hasFullFoodHistory()) {
                return false;
            }
            int homeBuildingLevel = citizen.getHomeBuilding().getBuildingLevelEquivalent();
            if (homeBuildingLevel <= 2) {
                return false;
            }
            ICitizenFoodHandler.CitizenFoodStats happinessStats = citizen.getCitizenFoodHandler().getFoodHappinessStats();
            return happinessStats.quality() < homeBuildingLevel - 2 && happinessStats.quality() >= homeBuildingLevel - 2 - 1;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.no.fooddiversity"), citizen -> {
            if (citizen.getHomeBuilding() == null || !citizen.getCitizenFoodHandler().hasFullFoodHistory()) {
                return false;
            }
            int homeBuildingLevel = citizen.getHomeBuilding().getBuildingLevelEquivalent();
            if (homeBuildingLevel <= 1) {
                return false;
            }
            ICitizenFoodHandler.CitizenFoodStats happinessStats = citizen.getCitizenFoodHandler().getFoodHappinessStats();
            return happinessStats.diversity() < homeBuildingLevel && (double)happinessStats.diversity() >= (double)homeBuildingLevel / 2.0;
        });
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.beekeeper.noflowers"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && ((ItemListModule)((BuildingBeekeeper)citizen.getWorkBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"))).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.raining"), citizen -> citizen.getEntity().isPresent() && citizen.getEntity().get().m_20193_().m_46471_() && !citizen.getColony().getRaiderManager().isRaided() && !citizen.getCitizenMournHandler().isMourning());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.raid"), citizen -> citizen.getEntity().isPresent() && citizen.getColony().getRaiderManager().isRaided());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.sleeping"), citizen -> citizen.getEntity().isPresent() && citizen.isAsleep());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.mourning"), citizen -> citizen.getEntity().isPresent() && citizen.getCitizenMournHandler().isMourning() && !citizen.getColony().getRaiderManager().isRaided());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearwork"), citizen -> citizen.getWorkBuilding() != null && !citizen.getWorkBuilding().isGuardBuildingNear());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.noguardnearhome"), citizen -> citizen.getHomeBuilding() != null && !citizen.getHomeBuilding().isGuardBuildingNear());
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.noquarry"), citizen -> citizen.getJob() instanceof JobQuarrier && ((JobQuarrier)citizen.getJob()).findQuarry() == null);
        InteractionValidatorRegistry.registerStandardPredicate((Component)Component.m_237115_((String)"com.minecolonies.coremod.quarrier.finishedquarry"), citizen -> citizen.getJob() instanceof JobQuarrier && ((JobQuarrier)citizen.getJob()).findQuarry() != null && ((QuarryModule)((JobQuarrier)citizen.getJob()).findQuarry().getFirstModuleOccurance(QuarryModule.class)).isFinished());
    }
}

