/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static Player getPlayerOfFakePlayer(@NotNull Player player, @NotNull Level world) {
        Player tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.m_46003_(player.m_20148_())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static Entity getPlayerByUUID(@NotNull Level world, @NotNull UUID id) {
        return world.m_46003_(id);
    }

    public static List<Entity> getEntitiesFromID(@NotNull Level world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((Level)world).m_6815_(arg_0)).collect(Collectors.toList());
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = Mth.m_14175_((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public static boolean checkForFreeSpace(@NotNull Level world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.m_6630_(i)) && !world.m_8055_(groundPosition.m_6630_(i)).m_204336_(BlockTags.f_13035_)) continue;
            return false;
        }
        return BlockUtils.isAnySolid((BlockState)world.m_8055_(groundPosition));
    }

    public static boolean solidOrLiquid(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockState state = world.m_8055_(blockPos);
        return state.m_278721_() || BlockUtils.isAnySolid((BlockState)state);
    }

    @Nullable
    public static BlockPos getSpawnPoint(Level world, BlockPos nearPoint) {
        return BlockPosUtil.findAround(world, nearPoint, 5, 5, (w, p) -> {
            if (EntityUtils.checkValidSpawn(w, p, 2)) {
                for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
                    if (!EntityUtils.checkValidSpawn(w, p.m_5484_(dir, 1), 2)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean checkValidSpawn(@NotNull BlockGetter world, BlockPos pos, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.m_8055_(pos.m_6630_(dy));
            if (state.m_204336_(ModTags.validSpawn) || !PathfindingUtils.isLiquid(state) && !ShapeUtil.hasCollision(world, pos.m_6630_(dy), state)) continue;
            return false;
        }
        return SurfaceType.getSurfaceType(world, world.m_8055_(pos.m_7495_()), pos.m_7495_()) == SurfaceType.WALKABLE || SurfaceType.getSurfaceType(world, world.m_8055_(pos.m_6625_(2)), pos.m_6625_(2)) == SurfaceType.WALKABLE;
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z, double speedFactor) {
        if (living instanceof AbstractFastMinecoloniesEntity) {
            AbstractFastMinecoloniesEntity entity = (AbstractFastMinecoloniesEntity)living;
            return EntityNavigationUtils.walkToPos(entity, new BlockPos(x, y, z), 4, true, speedFactor);
        }
        return true;
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z, int range) {
        if (x == 0 && y == 0 && z == 0) {
            return false;
        }
        if (!EntityUtils.isLivingAtSite(entity, x, y, z, 512)) {
            BlockPos spawnPoint = EntityUtils.getSpawnPoint(entity.m_20193_(), new BlockPos(x, y, z));
            if (spawnPoint == null) {
                spawnPoint = new BlockPos(x, y, z);
            }
            entity.m_7678_((double)spawnPoint.m_123341_() + 0.5, (double)spawnPoint.m_123342_(), (double)spawnPoint.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            return true;
        }
        return EntityUtils.isLivingAtSite(entity, x, y, z, range);
    }

    public static boolean isLivingAtSite(@NotNull LivingEntity entityLiving, int x, int y, int z, int range) {
        BlockPos pos = BlockPos.m_274561_((double)entityLiving.m_20185_(), (double)entityLiving.m_20186_(), (double)entityLiving.m_20189_());
        return (double)BlockPosUtil.distSqr(pos, x, y, z) < MathUtils.square(range);
    }

    public static boolean isFlying(LivingEntity target) {
        return target != null && (target.f_19812_ || !target.m_20096_()) && target.f_19789_ <= 0.1f && target.m_9236_().m_46859_(target.m_20183_().m_6625_(2));
    }

    public static Predicate<Entity> pushableBy() {
        return EntitySelector.f_20408_.and(localEntity -> {
            if (!localEntity.m_6094_()) {
                return false;
            }
            return !localEntity.f_19853_.f_46443_ || localEntity instanceof Player && ((Player)localEntity).m_7578_();
        });
    }
}

