/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkLoadStorage {
    public static final String TAG_CLAIM_LIST = "claimsToAdd";
    private static final String TAG_COLONIES_TO_ADD = "coloniesToAdd";
    private static final String TAG_COLONIES_TO_REMOVE = "coloniesToRemove";
    private static final int MAX_CHUNK_CLAIMS = 20;
    private final List<Short> owningChanges = new ArrayList<Short>();
    private final List<Short> coloniesToRemove = new ArrayList<Short>();
    private final List<Short> coloniesToAdd = new ArrayList<Short>();
    private final long xz;
    private final ResourceLocation dimension;
    private final List<Tuple<Short, BlockPos>> claimingBuilding = new ArrayList<Tuple<Short, BlockPos>>();
    private final List<Tuple<Short, BlockPos>> unClaimingBuilding = new ArrayList<Tuple<Short, BlockPos>>();

    public ChunkLoadStorage(CompoundTag compound) {
        if (compound.m_128441_("id")) {
            this.owningChanges.add(compound.m_128448_("id"));
        }
        this.xz = compound.m_128454_("pos");
        this.dimension = new ResourceLocation(compound.m_128461_("dimension"));
        this.owningChanges.addAll(NBTUtils.streamCompound(compound.m_128437_(TAG_CLAIM_LIST, 10)).map(tempCompound -> tempCompound.m_128448_("colony")).collect(Collectors.toList()));
        this.coloniesToAdd.addAll(NBTUtils.streamCompound(compound.m_128437_(TAG_COLONIES_TO_ADD, 10)).map(tempCompound -> tempCompound.m_128448_("colony")).collect(Collectors.toList()));
        this.coloniesToRemove.addAll(NBTUtils.streamCompound(compound.m_128437_(TAG_COLONIES_TO_REMOVE, 10)).map(tempCompound -> tempCompound.m_128448_("colony")).collect(Collectors.toList()));
        this.claimingBuilding.addAll(NBTUtils.streamCompound(compound.m_128437_("buildingsClaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
        this.unClaimingBuilding.addAll(NBTUtils.streamCompound(compound.m_128437_("buildingUnclaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
    }

    public ChunkLoadStorage(int colonyId, long xz, boolean add, ResourceLocation dimension, boolean forceOwnership) {
        this.owningChanges.add((short)(forceOwnership && add ? colonyId : 0));
        this.xz = xz;
        this.dimension = dimension;
        if (add) {
            this.coloniesToAdd.add((short)colonyId);
        } else {
            this.coloniesToRemove.add((short)colonyId);
        }
    }

    public ChunkLoadStorage(int colonyId, long xz, ResourceLocation dimension, BlockPos building, boolean add) {
        this.xz = xz;
        this.dimension = dimension;
        if (add) {
            this.claimingBuilding.add(new Tuple<Short, BlockPos>((short)colonyId, building));
        } else {
            this.unClaimingBuilding.add(new Tuple<Short, BlockPos>((short)colonyId, building));
        }
    }

    public CompoundTag toNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("pos", this.xz);
        compound.m_128359_("dimension", this.dimension.toString());
        compound.m_128365_(TAG_CLAIM_LIST, (Tag)this.owningChanges.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toListNBT()));
        compound.m_128365_(TAG_COLONIES_TO_ADD, (Tag)this.coloniesToAdd.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toListNBT()));
        compound.m_128365_(TAG_COLONIES_TO_REMOVE, (Tag)this.coloniesToRemove.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toListNBT()));
        compound.m_128365_("buildings", (Tag)this.claimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toListNBT()));
        compound.m_128365_("buildings", (Tag)this.unClaimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toListNBT()));
        return compound;
    }

    private static CompoundTag getCompoundOfColonyId(int id) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("colony", id);
        return compound;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public long getXz() {
        return this.xz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLoadStorage storage = (ChunkLoadStorage)o;
        return this.xz == storage.xz && this.dimension == storage.dimension && Objects.equals(this.owningChanges, storage.owningChanges) && Objects.equals(this.coloniesToRemove, storage.coloniesToRemove) && Objects.equals(this.coloniesToAdd, storage.coloniesToAdd) && Objects.equals(this.claimingBuilding, storage.claimingBuilding) && Objects.equals(this.unClaimingBuilding, storage.unClaimingBuilding);
    }

    public int hashCode() {
        return Objects.hash(this.owningChanges, this.coloniesToRemove, this.coloniesToAdd, this.xz, this.dimension, this.claimingBuilding, this.unClaimingBuilding);
    }

    public void applyToCap(IColonyTagCapability cap, LevelChunk chunk) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            int amountOfOperations = Math.max(Math.max(this.owningChanges.size(), this.coloniesToAdd.size()), this.coloniesToRemove.size());
            for (int i = 0; i < amountOfOperations; ++i) {
                short claimID;
                if (i < this.owningChanges.size() && (claimID = this.owningChanges.get(i).shortValue()) > 0) {
                    cap.setOwningColony(claimID, chunk);
                }
                if (i < this.coloniesToAdd.size() && this.coloniesToAdd.get(i) > 0) {
                    cap.addColony(this.coloniesToAdd.get(i).shortValue(), chunk);
                }
                if (i >= this.coloniesToRemove.size() || this.coloniesToRemove.get(i) <= 0) continue;
                cap.removeColony(this.coloniesToRemove.get(i).shortValue(), chunk);
            }
        } else {
            for (Tuple<Short, BlockPos> tuple : this.unClaimingBuilding) {
                cap.removeBuildingClaim(tuple.getA().shortValue(), tuple.getB(), chunk);
            }
            for (Tuple<Short, BlockPos> tuple : this.claimingBuilding) {
                cap.addBuildingClaim(tuple.getA().shortValue(), tuple.getB(), chunk);
            }
        }
        chunk.m_8092_(true);
    }

    public boolean isEmpty() {
        return this.coloniesToAdd.isEmpty() && this.coloniesToRemove.isEmpty();
    }

    public void merge(ChunkLoadStorage newStorage) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            this.owningChanges.addAll(newStorage.owningChanges);
            this.coloniesToAdd.addAll(newStorage.coloniesToAdd);
            this.coloniesToRemove.addAll(newStorage.coloniesToRemove);
            if (this.coloniesToAdd.size() > 20) {
                this.owningChanges.clear();
                this.coloniesToAdd.clear();
                this.coloniesToRemove.clear();
            }
        } else {
            this.claimingBuilding.removeIf(newStorage.unClaimingBuilding::contains);
            this.unClaimingBuilding.removeIf(newStorage.claimingBuilding::contains);
            for (Tuple<Short, BlockPos> tuple : newStorage.unClaimingBuilding) {
                if (this.unClaimingBuilding.contains(tuple)) continue;
                this.unClaimingBuilding.add(tuple);
            }
            for (Tuple<Short, BlockPos> tuple : newStorage.claimingBuilding) {
                if (this.claimingBuilding.contains(tuple)) continue;
                this.claimingBuilding.add(tuple);
            }
        }
    }

    private static CompoundTag writeTupleToNBT(Tuple<Short, BlockPos> tuple) {
        CompoundTag compound = new CompoundTag();
        compound.m_128376_("colony", tuple.getA().shortValue());
        BlockPosUtil.write(compound, "building", tuple.getB());
        return compound;
    }

    private static Tuple<Short, BlockPos> readTupleFromNbt(CompoundTag compound) {
        return new Tuple<Short, BlockPos>(compound.m_128448_("colony"), BlockPosUtil.read(compound, "building"));
    }
}

