/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockStateStorage {
    private final BlockState state;
    private final List<Property<?>> propertyList;
    private int hashCode;
    private final boolean exclude;

    public BlockStateStorage(@NotNull BlockState state, @NotNull List<Property<?>> compareProperties, boolean exclude) {
        this.state = state;
        this.propertyList = compareProperties;
        this.exclude = exclude;
        this.hashCode = state.m_60734_().hashCode();
        if (!exclude) {
            for (Property<?> prop : compareProperties) {
                if (!state.m_61138_(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.m_61143_(prop).hashCode();
            }
        } else {
            for (Property prop : state.m_61147_()) {
                if (compareProperties.contains(prop)) continue;
                this.hashCode += prop.hashCode();
                this.hashCode += state.m_61143_(prop).hashCode();
            }
        }
    }

    public BlockState getState() {
        return this.state;
    }

    public List<Property<?>> getCompareProperties() {
        return this.propertyList;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateStorage comparingToStorage = (BlockStateStorage)o;
        if (comparingToStorage.getState() == this.state) {
            return true;
        }
        if (this.exclude) {
            for (Property prop : this.state.m_61147_()) {
                if (this.getCompareProperties().contains(prop)) continue;
                if (!comparingToStorage.getState().m_61138_(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().m_61143_(prop).equals(this.state.m_61143_(prop))) continue;
                return false;
            }
        } else {
            for (Property<?> prop : this.propertyList) {
                if (!comparingToStorage.getState().m_61138_(prop)) {
                    return false;
                }
                if (comparingToStorage.getState().m_61143_(prop).equals(this.state.m_61143_(prop))) continue;
                return false;
            }
        }
        return true;
    }
}

