/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ContainerCrafting
extends AbstractContainerMenu {
    public final CraftingContainer craftMatrix;
    public final ResultContainer craftResult = new ResultContainer();
    private final Slot craftResultSlot;
    private final DataSlot switchableSlot;
    private final DataSlot recipeIndexSlot;
    private final List<ItemStack> remainingItems;
    private final boolean complete;
    private final Level world;
    private final Inventory inv;
    private final BlockPos pos;
    private final int moduleId;

    public static ContainerCrafting fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        boolean complete = packetBuffer.readBoolean();
        BlockPos tePos = packetBuffer.m_130135_();
        int moduleId = packetBuffer.readInt();
        return new ContainerCrafting(windowId, inv, complete, tePos, moduleId);
    }

    public ContainerCrafting(int windowId, Inventory inv, boolean complete, BlockPos pos, int moduleId) {
        super((MenuType)ModContainers.craftingGrid.get(), windowId);
        int j;
        int i;
        this.moduleId = moduleId;
        this.world = inv.f_35978_.m_9236_();
        this.inv = inv;
        this.complete = complete;
        this.pos = pos;
        this.craftMatrix = complete ? new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3) : new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
        this.craftResultSlot = this.m_38897_((Slot)new ResultSlot(inv.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 124, 35){

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        });
        for (i = 0; i < this.craftMatrix.m_39347_(); ++i) {
            for (j = 0; j < this.craftMatrix.m_39346_(); ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * (complete ? 3 : 2), 30 + j * 18, 17 + i * 18){

                    public int m_6641_() {
                        return 1;
                    }

                    @NotNull
                    public ItemStack m_6201_(int par1) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_5857_(ItemStack par1ItemStack) {
                        return true;
                    }

                    public boolean m_8010_(Player par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.switchableSlot = DataSlot.m_39401_();
        this.recipeIndexSlot = DataSlot.m_39401_();
        this.m_38895_(this.switchableSlot);
        this.m_38895_(this.recipeIndexSlot);
        this.remainingItems = new ArrayList<ItemStack>();
        this.m_6199_((Container)this.craftMatrix);
    }

    public void m_6199_(Container inventoryIn) {
        if (!this.world.f_46443_) {
            ServerPlayer player = (ServerPlayer)this.inv.f_35978_;
            List<CraftingRecipe> recipes = player.f_8924_.m_129894_().m_44056_(RecipeType.f_44107_, (Container)this.craftMatrix, this.world).stream().filter(recipe -> recipe.m_5598_() || !this.world.m_46469_().m_46207_(GameRules.f_46151_) || player.m_8952_().m_12709_((Recipe)recipe) || player.m_7500_()).toList();
            if (recipes.isEmpty()) {
                this.switchableSlot.m_6422_(0);
                this.craftResultSlot.m_5852_(ItemStack.f_41583_);
            } else {
                this.switchableSlot.m_6422_(recipes.size());
                this.recipeIndexSlot.m_6422_(this.recipeIndexSlot.m_6501_() % recipes.size());
                ItemStack stack = recipes.get(this.recipeIndexSlot.m_6501_()).m_5874_((Container)this.craftMatrix, this.world.m_9598_());
                this.craftResultSlot.m_5852_(stack);
            }
        }
        super.m_6199_(inventoryIn);
    }

    public boolean canSwitchRecipes() {
        return this.switchableSlot.m_6501_() > 1;
    }

    public void switchRecipes() {
        this.recipeIndexSlot.m_6422_(this.recipeIndexSlot.m_6501_() + 1);
        this.m_6199_((Container)this.craftMatrix);
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return true;
    }

    public void m_150399_(int slotId, int clickedButton, @NotNull ClickType mode, @NotNull Player playerIn) {
        if (slotId >= 1 && slotId < 5 + (this.complete ? 5 : 0)) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                this.handleSlotClick(slot, this.m_142621_());
                return;
            }
            return;
        }
        if (mode == ClickType.QUICK_MOVE) {
            return;
        }
        super.m_150399_(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slot.m_5852_(copy);
        } else if (slot.m_7993_().m_41613_() > 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return slot.m_7993_().m_41777_();
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        int total_crafting_slots = 5 + (this.complete ? 5 : 0);
        if (index <= total_crafting_slots) {
            return ItemStack.f_41583_;
        }
        int total_slots = 41 + (this.complete ? 5 : 0);
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, total_crafting_slots, total_slots, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index < 32 ? !this.m_38903_(itemstack1, 32, total_slots, false) : index < total_slots && !this.m_38903_(itemstack1, total_crafting_slots, 32, false) || !this.m_38903_(itemstack1, total_crafting_slots, total_slots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.craftResultSlot && super.m_5882_(stack, slotIn);
    }

    public Level getWorldObj() {
        return this.world;
    }

    public Player getPlayer() {
        return this.inv.f_35978_;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public CraftingContainer getInv() {
        return this.craftMatrix;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<ItemStack> getRemainingItems() {
        Optional iRecipe = this.world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, this.world);
        if (iRecipe.isPresent()) {
            NonNullList ri = ((CraftingRecipe)iRecipe.get()).m_7457_((Container)this.craftMatrix);
            this.remainingItems.clear();
            for (int i = 0; i < ri.size(); ++i) {
                if (((ItemStack)ri.get(i)).m_41619_()) continue;
                this.remainingItems.add((ItemStack)ri.get(i));
            }
        }
        return this.remainingItems;
    }

    public int getModuleId() {
        return this.moduleId;
    }
}

