/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.equipment.registry;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class EquipmentTypeEntry {
    private final ResourceLocation registryName;
    private final Component displayName;
    private final BiPredicate<ItemStack, EquipmentTypeEntry> isEquipment;
    private final BiFunction<ItemStack, EquipmentTypeEntry, Integer> itemLevel;

    private EquipmentTypeEntry(Component displayName, BiPredicate<ItemStack, EquipmentTypeEntry> isEquipment, BiFunction<ItemStack, EquipmentTypeEntry, Integer> itemLevel, ResourceLocation registryName) {
        this.displayName = displayName;
        this.isEquipment = isEquipment;
        this.itemLevel = itemLevel;
        this.registryName = registryName;
    }

    public static ResourceLocation parseResourceLocation(String serialized) {
        ResourceLocation result = new ResourceLocation(serialized);
        return EquipmentTypeEntry.parseResourceLocation(result);
    }

    public static ResourceLocation parseResourceLocation(ResourceLocation serialized) {
        String namespace = serialized.m_135827_().equals("minecraft") ? "minecolonies" : serialized.m_135827_();
        String path = serialized.m_135815_().isEmpty() ? ((EquipmentTypeEntry)ModEquipmentTypes.none.get()).registryName.m_135815_() : serialized.m_135815_();
        return new ResourceLocation(namespace, path);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public boolean checkIsEquipment(ItemStack itemStack) {
        return this.isEquipment.test(itemStack, this);
    }

    public int getMiningLevel(ItemStack itemStack) {
        return this.isEquipment.test(itemStack, this) ? this.itemLevel.apply(itemStack, this) : -1;
    }

    public static class Comparator
    implements java.util.Comparator<EquipmentTypeEntry> {
        @Override
        public int compare(EquipmentTypeEntry o1, EquipmentTypeEntry o2) {
            return o1.registryName.compareTo(o2.registryName);
        }
    }

    public static class Builder {
        private ResourceLocation registryName;
        private Component displayName;
        private BiPredicate<ItemStack, EquipmentTypeEntry> isEquipment;
        private BiFunction<ItemStack, EquipmentTypeEntry, Integer> itemLevel;

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder setDisplayName(Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setIsEquipment(BiPredicate<ItemStack, EquipmentTypeEntry> isEquipment) {
            this.isEquipment = isEquipment;
            return this;
        }

        public Builder setEquipmentLevel(BiFunction<ItemStack, EquipmentTypeEntry, Integer> itemLevel) {
            this.itemLevel = itemLevel;
            return this;
        }

        public EquipmentTypeEntry build() {
            return new EquipmentTypeEntry(this.displayName, this.isEquipment, this.itemLevel, this.registryName);
        }
    }
}

