/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.AbstractHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class TimeBasedHappinessModifier
extends AbstractHappinessModifier
implements ITimeBasedHappinessModifier {
    private BiPredicate<TimeBasedHappinessModifier, ICitizenData> dayRollOverPredicate;
    private List<Tuple<Integer, Double>> timeBasedFactor = new ArrayList<Tuple<Integer, Double>>();
    private int days = 0;

    @SafeVarargs
    public TimeBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, Tuple<Integer, Double> ... timeBasedFactor) {
        this(id, weight, supplier, (TimeBasedHappinessModifier modifier, ICitizenData data) -> modifier.getFactor((ICitizenData)data) < 1.0, timeBasedFactor);
    }

    @SafeVarargs
    public TimeBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, BiPredicate<TimeBasedHappinessModifier, ICitizenData> dayRollOverPredicate, Tuple<Integer, Double> ... timeBasedFactor) {
        super(id, weight, supplier);
        this.dayRollOverPredicate = dayRollOverPredicate;
        this.timeBasedFactor = List.of(timeBasedFactor);
    }

    public TimeBasedHappinessModifier() {
    }

    @Override
    public double getFactor(ICitizenData citizenData) {
        double baseFactor;
        double factor = baseFactor = super.getFactor(citizenData);
        if (baseFactor < 1.0) {
            for (Tuple<Integer, Double> tuple : this.timeBasedFactor) {
                if (this.days < tuple.getA()) continue;
                factor = baseFactor * tuple.getB();
            }
        }
        return factor;
    }

    @Override
    public void reset() {
        this.days = 0;
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void dayEnd(ICitizenData data) {
        if (this.dayRollOverPredicate.test(this, data)) {
            ++this.days;
        } else {
            this.reset();
        }
    }

    @Override
    public void read(CompoundTag compoundNBT, boolean persist) {
        super.read(compoundNBT, persist);
        this.days = compoundNBT.m_128451_("day");
        if (!persist) {
            ListTag listTag = compoundNBT.m_128437_("List", 10);
            ArrayList<Tuple<Integer, Double>> list = new ArrayList<Tuple<Integer, Double>>();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag entryTag = listTag.m_128728_(i);
                list.add(new Tuple<Integer, Double>(entryTag.m_128451_("day"), entryTag.m_128459_("Value")));
            }
            this.timeBasedFactor = list;
        }
    }

    @Override
    public void write(CompoundTag compoundNBT, boolean persist) {
        super.write(compoundNBT, persist);
        compoundNBT.m_128359_("modifier", HappinessRegistry.TIME_PERIOD_MODIFIER.toString());
        compoundNBT.m_128405_("day", this.days);
        if (!persist) {
            ListTag listTag = new ListTag();
            for (Tuple<Integer, Double> entry : this.timeBasedFactor) {
                CompoundTag listEntry = new CompoundTag();
                listEntry.m_128405_("day", entry.getA().intValue());
                listEntry.m_128347_("Value", entry.getB().doubleValue());
                listTag.add((Object)listEntry);
            }
            compoundNBT.m_128365_("List", (Tag)listTag);
        }
    }
}

