/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.AbstractHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import net.minecraft.nbt.CompoundTag;

public final class ExpirationBasedHappinessModifier
extends AbstractHappinessModifier
implements ITimeBasedHappinessModifier {
    private int days;
    private int period;

    public ExpirationBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, int period) {
        super(id, weight, supplier);
        this.days = period;
        this.period = period;
    }

    public ExpirationBasedHappinessModifier() {
    }

    @Override
    public double getFactor(ICitizenData data) {
        if (this.days > 0 && this.days <= this.period) {
            return super.getFactor(data);
        }
        return 1.0;
    }

    @Override
    public void reset() {
        this.days = this.period;
    }

    @Override
    public void dayEnd(ICitizenData data) {
        if (this.days > 0) {
            --this.days;
        }
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void read(CompoundTag compoundNBT, boolean persist) {
        super.read(compoundNBT, persist);
        this.days = compoundNBT.m_128451_("day");
        this.period = compoundNBT.m_128451_("period");
    }

    @Override
    public void write(CompoundTag compoundNBT, boolean persist) {
        super.write(compoundNBT, persist);
        compoundNBT.m_128359_("modifier", HappinessRegistry.EXPIRATION_MODIFIER.toString());
        compoundNBT.m_128405_("day", this.days);
        compoundNBT.m_128405_("period", this.period);
    }
}

