/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PrivateCrafting
extends AbstractCrafting {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(PrivateCrafting.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public PrivateCrafting(@NotNull ItemStack stack, int count, int minCount, IToken<?> recipeToken) {
        super(stack, count, minCount, recipeToken);
    }

    public static CompoundTag serialize(IFactoryController controller, PrivateCrafting input) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Stack", (Tag)input.getStack().serializeNBT());
        compound.m_128405_("Count", input.getCount());
        compound.m_128405_("MinCount", input.getMinCount());
        CompoundTag tokenCompound = StandardFactoryController.getInstance().serialize(input.getRecipeID());
        compound.m_128365_("Token", (Tag)tokenCompound);
        return compound;
    }

    public static PrivateCrafting deserialize(IFactoryController controller, CompoundTag compound) {
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.m_128469_("Stack"));
        int count = compound.m_128451_("Count");
        int minCount = compound.m_128451_("MinCount");
        IToken token = null;
        if (!compound.m_128441_("Token")) {
            throw new IllegalArgumentException("Old Data - Missing Token!");
        }
        token = (IToken)StandardFactoryController.getInstance().deserialize(compound.m_128469_("Token"));
        return new PrivateCrafting(stack, count, minCount == 0 ? count : minCount, token);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, PrivateCrafting input) {
        buffer.m_130055_(input.getStack());
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinCount());
        StandardFactoryController.getInstance().serialize(buffer, input.getRecipeID());
    }

    public static PrivateCrafting deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(buffer);
        return new PrivateCrafting(stack, count, minCount == 0 ? count : minCount, token);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

