/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.blocks.interfaces.IBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.tileentities.TileEntityColonyFlag;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractColonyFlagBanner<B extends AbstractColonyFlagBanner<B>>
extends AbstractBannerBlock
implements IBlockMinecolonies<AbstractColonyFlagBanner<B>> {
    public static final String REGISTRY_NAME = "colony_banner";
    public static final String REGISTRY_NAME_WALL = "colony_wall_banner";

    public AbstractColonyFlagBanner() {
        super(DyeColor.WHITE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_));
    }

    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityColonyFlag(blockPos, blockState);
    }

    public void m_6402_(Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityColonyFlag) {
            TileEntityColonyFlag flagTileEntity = (TileEntityColonyFlag)te;
            IColony colony = IColonyManager.getInstance().getIColony(worldIn, pos);
            if (colony == null && placer instanceof Player) {
                colony = IColonyManager.getInstance().getIColonyByOwner(worldIn, (Player)placer);
            }
            if (colony != null) {
                flagTileEntity.colonyId = colony.getID();
            }
        }
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityColonyFlag) {
            if (worldIn instanceof ClientLevel) {
                ((TileEntityColonyFlag)tileentity).getItemClient();
            } else {
                ((TileEntityColonyFlag)tileentity).getItemServer();
            }
        }
        return super.m_7397_(worldIn, pos, state);
    }

    @Override
    public AbstractColonyFlagBanner<B> registerBlock(IForgeRegistry<Block> registry) {
        registry.register(this.getRegistryName(), (Object)this);
        return this;
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
    }
}

