/*
 * Decompiled with CFR 0.152.
 */
package appeng.mixins.tests;

import appeng.server.testworld.GameTestPlotAdapter;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureUtils.class}, priority=0)
public class StructureUtilsMixin {
    @Inject(method={"getStructureTemplate"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getStructureTemplate(String structureName, ServerLevel serverLevel, CallbackInfoReturnable<StructureTemplate> cri) {
        StructureTemplate template = GameTestPlotAdapter.getStructureTemplate(structureName);
        if (template != null) {
            cri.setReturnValue((Object)template);
        }
    }

    @Inject(method={"createStructureBlock"}, at={@At(value="RETURN")})
    private static void createStructureBlock(String structureName, BlockPos pos, Rotation rotation, ServerLevel serverLevel, boolean bl, CallbackInfoReturnable<StructureBlockEntity> cri) {
        GameTestPlotAdapter.createStructure((StructureBlockEntity)cri.getReturnValue());
    }
}

