/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class EncodePatternTransferHandler<T extends PatternEncodingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, Object> {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private final MenuType<T> menuType;
    private final Class<T> menuClass;
    private final IRecipeTransferHandlerHelper helper;
    @Nullable
    private IIngredientVisibility ingredientVisibility;

    public EncodePatternTransferHandler(MenuType<T> menuType, Class<T> menuClass, IRecipeTransferHandlerHelper helper) {
        this.menuType = menuType;
        this.menuClass = menuClass;
        this.helper = helper;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, Object recipeBase, IRecipeSlotsView slotsView, Player player, boolean maxTransfer, boolean doTransfer) {
        boolean craftingRecipe;
        Recipe recipe = null;
        if (recipeBase instanceof Recipe) {
            recipe = (Recipe)recipeBase;
        }
        if ((craftingRecipe = EncodingHelper.isSupportedCraftingRecipe(recipe)) && !this.fitsIn3x3Grid(recipe, slotsView)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                EncodingHelper.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(slotsView), this::isIngredientVisible);
            } else {
                EncodingHelper.encodeProcessingRecipe(menu, GenericEntryStackHelper.ofInputs(slotsView), GenericEntryStackHelper.ofOutputs(slotsView));
            }
        } else {
            List<IRecipeSlotView> craftableSlots = this.findCraftableSlots(menu, slotsView);
            return new ErrorRenderer(craftableSlots);
        }
        return null;
    }

    private boolean isIngredientVisible(ItemStack itemStack) {
        if (this.ingredientVisibility == null) {
            this.ingredientVisibility = ((JeiRuntimeAdapter)JEIFacade.instance()).getRuntime().getIngredientVisibility();
        }
        return this.ingredientVisibility.isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack);
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(IRecipeSlotsView recipeLayout) {
        List recipeSlots = recipeLayout.getSlotViews();
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            if (i < recipeSlots.size()) {
                IRecipeSlotView slot = (IRecipeSlotView)recipeSlots.get(i);
                result.add(slot.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).map(GenericStack::fromItemStack).filter(Objects::nonNull).toList());
                continue;
            }
            result.add(Collections.emptyList());
        }
        return result;
    }

    private List<IRecipeSlotView> findCraftableSlots(T menu, IRecipeSlotsView slotsView) {
        IClientRepo repo = ((MEStorageMenu)menu).getClientRepo();
        if (repo == null) {
            return List.of();
        }
        Set craftableKeys = repo.getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet());
        return slotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(slotView -> slotView.getAllIngredients().anyMatch(ingredient -> {
            GenericStack stack = GenericEntryStackHelper.ingredientToStack(ingredient);
            return stack != null && craftableKeys.contains(stack.what());
        })).toList();
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    public Class<? extends T> getContainerClass() {
        return this.menuClass;
    }

    public RecipeType<Object> getRecipeType() {
        return null;
    }

    private record ErrorRenderer(List<IRecipeSlotView> craftableSlots) implements IRecipeTransferError
    {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public int getButtonHighlightColor() {
            return 0;
        }

        public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)recipeX, (float)recipeY, 0.0f);
            for (IRecipeSlotView slotView : this.craftableSlots) {
                slotView.drawHighlight(guiGraphics, 0x400000FF);
            }
            poseStack.m_85849_();
            JEIPlugin.drawHoveringText(guiGraphics, TransferHelper.createEncodingTooltip(!this.craftableSlots.isEmpty()), mouseX, mouseY);
        }
    }
}

