/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.LightDarkMode;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.RenderContext;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public record SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics, LightDarkMode lightDarkMode) implements RenderContext
{
    public SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics) {
        this(viewport, guiGraphics, LightDarkMode.current());
    }

    @Override
    public int resolveColor(ColorValue ref) {
        return ref.resolve(this.lightDarkMode);
    }

    @Override
    public void fillRect(LytRect rect, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = this.poseStack().m_85850_().m_252922_();
        boolean z = false;
        builder.m_252986_(matrix, (float)rect.right(), (float)rect.y(), 0.0f).m_193479_(this.resolveColor(topRight)).m_5752_();
        builder.m_252986_(matrix, (float)rect.x(), (float)rect.y(), 0.0f).m_193479_(this.resolveColor(topLeft)).m_5752_();
        builder.m_252986_(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).m_193479_(this.resolveColor(bottomLeft)).m_5752_();
        builder.m_252986_(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).m_193479_(this.resolveColor(bottomRight)).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft, float u0, float v0, float u1, float v1) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (int)texture.m_117963_());
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = this.poseStack().m_85850_().m_252922_();
        boolean z = false;
        builder.m_252986_(matrix, (float)rect.right(), (float)rect.y(), 0.0f).m_7421_(u1, v0).m_193479_(this.resolveColor(topRight)).m_5752_();
        builder.m_252986_(matrix, (float)rect.x(), (float)rect.y(), 0.0f).m_7421_(u0, v0).m_193479_(this.resolveColor(topLeft)).m_5752_();
        builder.m_252986_(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).m_7421_(u0, v1).m_193479_(this.resolveColor(bottomLeft)).m_5752_();
        builder.m_252986_(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).m_7421_(u1, v1).m_193479_(this.resolveColor(bottomRight)).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTriangle(Vec2 p1, Vec2 p2, Vec2 p3, ColorValue color) {
        int resolvedColor = this.resolveColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = this.poseStack().m_85850_().m_252922_();
        boolean z = false;
        builder.m_252986_(matrix, p1.f_82470_, p1.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        builder.m_252986_(matrix, p2.f_82470_, p2.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        builder.m_252986_(matrix, p3.f_82470_, p3.f_82471_, 0.0f).m_193479_(resolvedColor).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @Override
    public void renderItem(ItemStack stack, int x, int y, int z, float width, float height) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack pose = this.poseStack();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, (float)(z + 1));
        pose.m_85841_(width / 16.0f, height / 16.0f, 1.0f);
        this.guiGraphics().m_280480_(stack, 0, 0);
        this.guiGraphics().m_280370_(mc.f_91062_, stack, 0, 0);
        pose.m_85849_();
    }
}

