/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.IResizableWidget;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AETextField
extends EditBox
implements IResizableWidget,
ITooltip {
    private static final Blitter BLITTER = Blitter.texture("guis/text_field.png", 128, 128);
    private static final int PADDING = 2;
    private final int fontPad;
    private final ScreenStyle style;
    private int selectionColor;
    private List<Component> tooltipMessage = Collections.emptyList();
    @Nullable
    private Component placeholder;

    public AETextField(ScreenStyle style, Font fontRenderer, int xPos, int yPos, int width, int height) {
        super(fontRenderer, xPos + 2, yPos + 2, width - 4 - fontRenderer.m_92895_("_"), height - 4, (Component)Component.m_237119_());
        this.style = style;
        this.fontPad = fontRenderer.m_92895_("_");
        this.setSelectionColor(style.getColor(PaletteColor.TEXTFIELD_SELECTION).toARGB());
        this.m_94202_(style.getColor(PaletteColor.TEXTFIELD_TEXT).toARGB());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        VisualBounds bounds = this.getVisualBounds();
        return mouseX >= (double)bounds.left && mouseX < (double)bounds.right && mouseY >= (double)bounds.top && mouseY < (double)bounds.bottom;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            mouseX = Mth.m_14008_((double)mouseX, (double)this.m_252754_(), (double)(this.m_252754_() + this.f_93618_ - 1));
            mouseY = Mth.m_14008_((double)mouseY, (double)this.m_252907_(), (double)(this.m_252907_() + this.f_93619_ - 1));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.m_93696_() && this.m_94204_() && keyCode != 258 && keyCode != 256;
    }

    @Override
    public void move(Point pos) {
        super.m_252865_(pos.getX() + 2);
        this.m_253211_(pos.getY() + 2);
    }

    @Override
    public void resize(int width, int height) {
        super.m_93674_(width - 4 - this.fontPad);
        this.f_93619_ = height - 4;
    }

    public void selectAll() {
        this.m_94192_(0);
        this.m_94208_(this.m_94216_());
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.m_94213_()) {
            int yOffset = 0;
            if (!this.m_94222_()) {
                yOffset = 12;
            } else if (this.m_93696_()) {
                yOffset = 24;
            }
            VisualBounds bounds = this.getVisualBounds();
            BLITTER.src(0, yOffset, 1, 12).dest(bounds.left, bounds.top).blit(guiGraphics);
            int backgroundWidth = Math.min(126, bounds.right - bounds.left - 2);
            BLITTER.src(1, yOffset, backgroundWidth, 12).dest(bounds.left + 1, bounds.top).blit(guiGraphics);
            BLITTER.src(127, yOffset, 1, 12).dest(bounds.right - 1, bounds.top).blit(guiGraphics);
            super.m_87963_(guiGraphics, mouseX, mouseY, partial);
            if (this.placeholder != null && !this.m_93696_() && this.m_94155_().isEmpty()) {
                Font font = Minecraft.m_91087_().f_91062_;
                guiGraphics.m_280614_(font, this.placeholder, this.m_252754_(), this.m_252907_(), this.style.getColor(PaletteColor.TEXTFIELD_PLACEHOLDER).toARGB(), false);
            }
        }
    }

    public void m_264315_(GuiGraphics guiGraphics, int startX, int startY, int endX, int endY) {
        if (!this.m_93696_()) {
            return;
        }
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        ++startX;
        --endX;
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        endX = Mth.m_14045_((int)endX, (int)this.m_252754_(), (int)(this.m_252754_() + this.f_93618_));
        startX = Mth.m_14045_((int)startX, (int)this.m_252754_(), (int)(this.m_252754_() + this.f_93618_));
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        guiGraphics.m_280509_(startX, startY -= 2, endX, endY, this.selectionColor);
        RenderSystem.disableColorLogicOp();
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.m_252754_() - 2, this.m_252907_() - 2, this.f_93618_ + 4 + this.fontPad, this.f_93619_ + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    @Override
    @NotNull
    public List<Component> getTooltipMessage() {
        return this.tooltipMessage;
    }

    public void setTooltipMessage(List<Component> tooltipMessage) {
        this.tooltipMessage = Objects.requireNonNull(tooltipMessage);
    }

    private VisualBounds getVisualBounds() {
        int left = this.m_252754_() - 2;
        int top = this.m_252907_() - 2;
        int right = left + this.f_93618_ + 4 + this.fontPad;
        return new VisualBounds(left, top, right, top + this.f_93619_ + 4);
    }

    public void setPlaceholder(Component placeholder) {
        this.placeholder = placeholder;
    }

    public Component getPlaceholder() {
        return this.placeholder;
    }

    private record VisualBounds(int left, int top, int right, int bottom) {
    }
}

