/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.client.Point;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.me.items.EncodingModePanel;
import appeng.client.gui.me.items.PatternEncodingTermScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class StonecuttingEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture("guis/pattern_modes.png").src(0, 141, 126, 68);
    private static final Blitter BG_SLOT = BG.copy().src(126, 141, 16, 18);
    private static final Blitter BG_SLOT_SELECTED = BG.copy().src(126, 159, 16, 18);
    private static final Blitter BG_SLOT_HOVER = BG.copy().src(126, 177, 16, 18);
    private static final int COLS = 4;
    private static final int ROWS = 3;
    private final Scrollbar scrollbar;

    public StonecuttingEncodingPanel(PatternEncodingTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.scrollbar = widgets.addScrollBar("stonecuttingPatternModeScrollbar", Scrollbar.SMALL);
        this.scrollbar.setRange(0, 0, 4);
        this.scrollbar.setCaptureMouseWheel(false);
    }

    @Override
    public void updateBeforeRender() {
        int totalRows = (this.menu.getStonecuttingRecipes().size() + 4 - 1) / 4;
        this.scrollbar.setRange(0, totalRows - 3, 3);
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.m_110085_() + 9, bounds.m_110086_() + bounds.m_110091_() - 164).blit(guiGraphics);
        this.drawRecipes(guiGraphics, bounds, mouse);
    }

    private RegistryAccess getRegistryAccess() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_9598_();
    }

    private void drawRecipes(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        List<StonecutterRecipe> recipes = this.menu.getStonecuttingRecipes();
        int startIndex = this.scrollbar.getCurrentScroll() * 4;
        int endIndex = startIndex + 12;
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceLocation selectedRecipe = this.menu.getStonecuttingRecipeId();
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            Rect2i slotBounds = this.getRecipeBounds(i - startIndex);
            StonecutterRecipe recipe = recipes.get(i);
            boolean selected = selectedRecipe != null && selectedRecipe.equals((Object)recipe.m_6423_());
            Blitter blitter = BG_SLOT;
            if (selected) {
                blitter = BG_SLOT_SELECTED;
            } else if (mouse.isIn(slotBounds)) {
                blitter = BG_SLOT_HOVER;
            }
            int renderX = bounds.m_110085_() + slotBounds.m_110085_();
            int renderY = bounds.m_110086_() + slotBounds.m_110086_();
            blitter.dest(renderX, renderY - 1).blit(guiGraphics);
            ItemStack resultItem = recipe.m_8043_(this.getRegistryAccess());
            guiGraphics.m_280480_(resultItem, renderX, renderY);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, resultItem, renderX, renderY);
        }
    }

    @Override
    public boolean onMouseDown(Point mousePos, int button) {
        StonecutterRecipe recipe = this.getRecipeAt(mousePos);
        if (recipe != null) {
            this.menu.setStonecuttingRecipeId(recipe.m_6423_());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        StonecutterRecipe recipe = this.getRecipeAt(new Point(mouseX, mouseY));
        if (recipe != null) {
            List<Component> lines = this.screen.m_280553_(recipe.m_8043_(this.getRegistryAccess()));
            return new Tooltip(lines);
        }
        return null;
    }

    @Nullable
    private StonecutterRecipe getRecipeAt(Point point) {
        List<StonecutterRecipe> recipes = this.menu.getStonecuttingRecipes();
        if (!recipes.isEmpty()) {
            int startIndex = this.scrollbar.getCurrentScroll() * 4;
            int endIndex = startIndex + 12;
            for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
                Rect2i slotBounds = this.getRecipeBounds(i - startIndex);
                if (!point.isIn(slotBounds)) continue;
                return recipes.get(i);
            }
        }
        return null;
    }

    private Rect2i getRecipeBounds(int index) {
        int col = index % 4;
        int row = index / 4;
        int slotX = this.x + 44 + col * BG_SLOT.getSrcWidth();
        int slotY = this.y + 8 + row * BG_SLOT.getSrcHeight();
        return new Rect2i(slotX, slotY, BG_SLOT.getSrcWidth(), BG_SLOT.getSrcHeight());
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        return this.scrollbar.onMouseWheel(mousePos, delta);
    }

    @Override
    public ItemStack getTabIconItem() {
        return new ItemStack((ItemLike)Items.f_42776_);
    }

    @Override
    public Component getTabTooltip() {
        return GuiText.StonecuttingPattern.text();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.scrollbar.setVisible(visible);
        this.screen.setSlotsHidden(SlotSemantics.STONECUTTING_INPUT, !visible);
    }
}

