/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableBusBreakingParticle;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.integration.abstraction.IAEFacade;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import org.jetbrains.annotations.Nullable;

public class CableBusBlock
extends AEBaseEntityBlock<CableBusBlockEntity>
implements IAEFacade,
SimpleWaterloggedBlock {
    private static final ICableBusContainer NULL_CABLE_BUS = new NullCableBusContainer();
    private static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)15);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static ThreadLocal<Direction> RENDERING_FACADE_DIRECTION = new ThreadLocal();

    public CableBusBlock() {
        super(CableBusBlock.glassProps().m_60955_().m_222994_().m_60988_().m_280606_().m_60953_(state -> (Integer)state.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof CableBusBlockEntity) {
            CableBusBlockEntity bus = (CableBusBlockEntity)object;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            bus.getCableBus().addPartDrops(drops);
            return drops;
        }
        return List.of();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        this.cb((BlockGetter)level, pos).animateTick(level, pos, rand);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.cb(level, pos).isProvidingWeakPower(side.m_122424_());
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        this.cb((BlockGetter)level, pos).onEntityCollision(entityIn);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.cb(level, pos).isProvidingStrongPower(side.m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT_LEVEL, WATERLOGGED});
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.cb((BlockGetter)level, pos).isLadder(entity);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return super.m_6864_(state, useContext) && this.cb((BlockGetter)useContext.m_43725_(), useContext.m_8083_()).isEmpty();
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        if (side == null) {
            return false;
        }
        return this.cb(level, pos).canConnectRedstone(side.m_122424_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Vec3 v3 = target.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        SelectedPart sp = this.cb(level, pos).selectPartLocal(v3);
        if (sp.part != null) {
            return new ItemStack(sp.part.getPartItem());
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return ItemStack.f_41583_;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.m_5776_()) {
            this.cb((BlockGetter)level, pos).onNeighborChanged((BlockGetter)level, pos, fromPos);
        }
    }

    private ICableBusContainer cb(BlockGetter level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        CableBusContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus();
        }
        return out == null ? NULL_CABLE_BUS : out;
    }

    @Nullable
    private IFacadeContainer fc(BlockGetter level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        IFacadeContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus().getFacadeContainer();
        }
        return out;
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        Vec3 hitVec = hit.m_82450_();
        Vec3 hitInBlock = new Vec3(hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82480_ - (double)pos.m_123342_(), hitVec.f_82481_ - (double)pos.m_123343_());
        return this.cb((BlockGetter)level, pos).activate(player, hand, hitInBlock) ? InteractionResult.m_19078_((boolean)level.m_5776_()) : InteractionResult.PASS;
    }

    public boolean recolorBlock(BlockGetter level, BlockPos pos, Direction side, DyeColor color, Player who) {
        try {
            return this.cb(level, pos).recolourBlock(side, AEColor.values()[color.ordinal()], who);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
    }

    @Override
    public BlockState getFacadeState(BlockGetter level, BlockPos pos, Direction side) {
        IFacadePart facade;
        IFacadeContainer container;
        if (side != null && (container = this.fc(level, pos)) != null && (facade = container.getFacade(side)) != null) {
            return facade.getBlockState();
        }
        return level.m_8055_(pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(level, pos);
        if (te == null) {
            return Shapes.m_83040_();
        }
        return te.getCableBus().getShape();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(level, pos);
        if (te == null) {
            return Shapes.m_83040_();
        }
        return te.getCableBus().getCollisionShape(context);
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, CableBusBlockEntity be) {
        if (currentState.m_60734_() != this) {
            return currentState;
        }
        int lightLevel = be.getCableBus().getLightValue();
        return (BlockState)super.updateBlockStateFromBlockEntity(currentState, be).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement(context.m_43725_(), context.m_8083_());
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        this.cb((BlockGetter)level, currentPos).onUpdateShape(level, currentPos, facing);
        return super.m_7417_(blockState, facing, facingState, level, currentPos, facingPos);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.cb((BlockGetter)level, pos).onNeighborChanged((BlockGetter)level, pos, neighbor);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine effectRenderer) {
                if (level.m_213780_().m_188499_()) {
                    return true;
                }
                if (target.m_6662_() != HitResult.Type.BLOCK) {
                    return false;
                }
                BlockPos blockPos = BlockPos.m_274561_((double)target.m_82450_().f_82479_, (double)target.m_82450_().f_82480_, (double)target.m_82450_().f_82481_);
                ICableBusContainer cb = CableBusBlock.this.cb((BlockGetter)level, blockPos);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(CableBusBlock.this.m_49966_());
                if (!(model instanceof CableBusBakedModel)) {
                    return true;
                }
                CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
                CableBusRenderState renderState = cb.getRenderState();
                List<TextureAtlasSprite> textures = cableBusModel.getParticleTextures(renderState);
                if (!textures.isEmpty()) {
                    TextureAtlasSprite texture = (TextureAtlasSprite)Util.m_214621_(textures, (RandomSource)level.m_213780_());
                    double x = target.m_82450_().f_82479_;
                    double y = target.m_82450_().f_82480_;
                    double z = target.m_82450_().f_82481_;
                    effectRenderer.m_107344_(new CableBusBreakingParticle((ClientLevel)level, x, y, z, texture).m_6569_(0.8f));
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine effectRenderer) {
                ICableBusContainer cb = CableBusBlock.this.cb((BlockGetter)level, pos);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(CableBusBlock.this.m_49966_());
                if (!(model instanceof CableBusBakedModel)) {
                    return true;
                }
                CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
                CableBusRenderState renderState = cb.getRenderState();
                List<TextureAtlasSprite> textures = cableBusModel.getParticleTextures(renderState);
                if (!textures.isEmpty()) {
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            for (int l = 0; l < 4; ++l) {
                                TextureAtlasSprite texture = (TextureAtlasSprite)Util.m_214621_(textures, (RandomSource)level.m_213780_());
                                double x = (double)pos.m_123341_() + ((double)j + 0.5) / 4.0;
                                double y = (double)pos.m_123342_() + ((double)k + 0.5) / 4.0;
                                double z = (double)pos.m_123343_() + ((double)l + 0.5) / 4.0;
                                CableBusBreakingParticle effect = new CableBusBreakingParticle((ClientLevel)level, x, y, z, x - (double)pos.m_123341_() - 0.5, y - (double)pos.m_123342_() - 0.5, z - (double)pos.m_123343_() - 0.5, texture);
                                effectRenderer.m_107344_((Particle)effect);
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        BlockEntity be;
        ModelDataManager modelDataManager = renderView.getModelDataManager();
        ModelData modelData = modelDataManager == null ? ((be = renderView.m_7702_(pos)) != null ? be.getModelData() : ModelData.EMPTY) : Objects.requireNonNullElse(modelDataManager.getAt(pos), ModelData.EMPTY);
        CableBusRenderState cableBusRenderState = (CableBusRenderState)modelData.get(CableBusRenderState.PROPERTY);
        if (cableBusRenderState != null) {
            FacadeRenderState facadeState;
            Direction renderingFacadeDir = RENDERING_FACADE_DIRECTION.get();
            EnumMap<Direction, FacadeRenderState> facades = cableBusRenderState.getFacades();
            if (side.m_122424_() != renderingFacadeDir && (facadeState = facades.get(side)) != null) {
                return facadeState.getSourceBlock();
            }
            if (renderingFacadeDir != null && facades.containsKey(renderingFacadeDir)) {
                return facades.get(renderingFacadeDir).getSourceBlock();
            }
        }
        return state;
    }
}

