/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.VibrationChamberBlockEntity;
import appeng.core.AEConfig;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.VibrationChamberMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public final class VibrationChamberBlock
extends AEBaseEntityBlock<VibrationChamberBlockEntity> {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public VibrationChamberBlock() {
        super(VibrationChamberBlock.metalProps().m_60978_(4.2f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, VibrationChamberBlockEntity be) {
        return (BlockState)currentState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(be.isOn));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.full();
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        VibrationChamberBlockEntity tc;
        if (InteractionUtil.isInAlternateUseMode(player)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_() && (tc = (VibrationChamberBlockEntity)this.getBlockEntity((BlockGetter)level, pos)) != null) {
            hit.m_82434_();
            MenuOpener.open(VibrationChamberMenu.TYPE, player, MenuLocators.forBlockEntity(tc));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        VibrationChamberBlockEntity tc = (VibrationChamberBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tc != null && tc.isOn) {
            double f1 = (float)pos.m_123341_() + 0.5f;
            double f2 = (float)pos.m_123342_() + 0.5f;
            double f3 = (float)pos.m_123343_() + 0.5f;
            Direction front = tc.getFront();
            Direction top = tc.getTop();
            int west_x = front.m_122430_() * top.m_122431_() - front.m_122431_() * top.m_122430_();
            int west_y = front.m_122431_() * top.m_122429_() - front.m_122429_() * top.m_122431_();
            int west_z = front.m_122429_() * top.m_122430_() - front.m_122430_() * top.m_122429_();
            f1 += (double)front.m_122429_() * 0.6;
            f2 += (double)front.m_122430_() * 0.6;
            f3 += (double)front.m_122431_() * 0.6;
            double ox = r.m_188500_();
            double oy = r.m_188500_() * (double)0.2f;
            f1 += (double)top.m_122429_() * (-0.3 + oy);
            f2 += (double)top.m_122430_() * (-0.3 + oy);
            f3 += (double)top.m_122431_() * (-0.3 + oy);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, f1 += (double)west_x * (0.3 * ox - 0.15), f2 += (double)west_y * (0.3 * ox - 0.15), f3 += (double)west_z * (0.3 * ox - 0.15), 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, f1, f2, f3, 0.0, 0.0, 0.0);
        }
    }
}

