/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemItemHandler
extends VanillaEntityItemCapabilityDelegator<IItemHandler>
implements IItemHandler {
    public VanillaEntityItemItemHandler(ItemEntity entity, Direction side) {
        super(entity, side);
    }

    @Override
    protected Capability<IItemHandler> getCapabilityType() {
        return ForgeCapabilities.ITEM_HANDLER;
    }

    public int getSlots() {
        return this.getCapability().map(IItemHandler::getSlots).orElse(0);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getCapability().map(itemHandler -> itemHandler.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getCapability().map(itemHandler -> {
            ItemStack innerStack = this.getItemStack();
            ItemStack ret = itemHandler.insertItem(slot, stack, simulate);
            if (stack.m_41613_() != ret.m_41613_() && !simulate) {
                this.updateItemStack(innerStack);
            }
            return ret;
        }).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getCapability().map(itemHandler -> {
            ItemStack innerStack = this.getItemStack();
            ItemStack ret = itemHandler.extractItem(slot, amount, simulate);
            if (!ret.m_41619_() && !simulate) {
                this.updateItemStack(innerStack);
            }
            return ret;
        }).orElse(ItemStack.f_41583_);
    }

    public int getSlotLimit(int slot) {
        return this.getCapability().map(itemHandler -> itemHandler.getSlotLimit(slot)).orElse(0);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getCapability().map(itemHandler -> itemHandler.isItemValid(slot, stack)).orElse(false);
    }
}

