/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MarketCategory
implements IRecipeCategory<IMarketEntry> {
    public static final ResourceLocation UID = new ResourceLocation("farmingforblockheads:market");
    public static final RecipeType<IMarketEntry> TYPE = new RecipeType(UID, IMarketEntry.class);
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/jei_market.png");
    private final IDrawable icon;
    private final IDrawableStatic background;

    public MarketCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.market));
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 86, 48);
    }

    public RecipeType<IMarketEntry> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("jei." + String.valueOf(UID)));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IMarketEntry recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getCostItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 54, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutputItem());
    }

    public void draw(IMarketEntry recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Component costText = this.getFormattedCostString(recipe);
        Font font = Minecraft.m_91087_().f_91062_;
        int stringWidth = font.m_92852_((FormattedText)costText);
        guiGraphics.m_280649_(font, costText.m_7532_(), 42 - stringWidth / 2, 35, 0xFFFFFF, true);
    }

    private Component getFormattedCostString(IMarketEntry entry) {
        MutableComponent result = Component.m_237110_((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().m_41613_(), entry.getCostItem().m_41611_()});
        ChatFormatting color = ChatFormatting.GREEN;
        if (entry.getCostItem().m_41720_() == Items.f_42415_) {
            color = ChatFormatting.AQUA;
        }
        result.m_130940_(color);
        return result;
    }
}

