/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.mixin.potion.PotionBrewingAccessor;
import com.almostreliable.morejs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.HashSet;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.StringUtils;

public abstract class PotionBrewingRegisterEvent
extends EventJS {
    protected void validate(Ingredient topInput, Ingredient bottomInput, ItemStack output) {
        Preconditions.checkArgument((topInput.m_43908_().length > 0 ? 1 : 0) != 0, (Object)"Top input must have at least one item");
        Preconditions.checkArgument((bottomInput.m_43908_().length > 0 ? 1 : 0) != 0, (Object)"Bottom input must have at least one item");
        Preconditions.checkArgument((!output.m_41619_() ? 1 : 0) != 0, (Object)"Output must not be empty");
    }

    protected void validateSimple(Potion from, Ingredient ingredient, Potion to) {
        Preconditions.checkNotNull((Object)from, (Object)"Input potion must not be null");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkNotNull((Object)to, (Object)"Output potion must not be null");
        Preconditions.checkArgument((ingredient.m_43908_().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
    }

    public abstract void addCustomBrewing(Ingredient var1, Ingredient var2, ItemStack var3);

    public abstract void addPotionBrewing(Ingredient var1, Potion var2, Potion var3);

    public void addPotionBrewing(Ingredient ingredient, Potion output) {
        this.addPotionBrewing(ingredient, Potions.f_43599_, output);
    }

    public void removeByPotion(@Nullable Potion input, @Nullable Ingredient ingredient, @Nullable Potion output) {
        PotionBrewingAccessor.getMixes().removeIf(mix -> {
            boolean matches;
            boolean matchesInput = input == null || this.getInputPotionFromMix((PotionBrewing.Mix<Potion>)mix) == input;
            boolean matchesIngredient = ingredient == null || Utils.matchesIngredient(ingredient, mix.f_43533_);
            boolean matchesOutput = output == null || this.getOutputPotionFromMix((PotionBrewing.Mix<Potion>)mix) == output;
            boolean bl = matches = matchesInput && matchesIngredient && matchesOutput;
            if (matches) {
                ConsoleJS.STARTUP.info((Object)("Removed potion brewing recipe: " + String.valueOf(BuiltInRegistries.f_256980_.m_7981_((Object)this.getInputPotionFromMix((PotionBrewing.Mix<Potion>)mix))) + " + " + StringUtils.abbreviate((String)mix.f_43533_.m_43942_().toString(), (int)64) + " -> " + String.valueOf(BuiltInRegistries.f_256980_.m_7981_((Object)this.getOutputPotionFromMix((PotionBrewing.Mix<Potion>)mix)))));
            }
            return matches;
        });
    }

    protected abstract Potion getInputPotionFromMix(PotionBrewing.Mix<Potion> var1);

    protected abstract Potion getOutputPotionFromMix(PotionBrewing.Mix<Potion> var1);

    protected abstract Item getOutputItemFromMix(PotionBrewing.Mix<Item> var1);

    public void removeContainer(Ingredient ingredient) {
        HashSet<Item> removed = new HashSet<Item>();
        ListIterator<Ingredient> containerIt = PotionBrewingAccessor.getAllowedContainers().listIterator();
        while (containerIt.hasNext()) {
            Ingredient ac = containerIt.next();
            if (!Utils.matchesIngredient(ac, ingredient)) continue;
            containerIt.remove();
            for (ItemStack item : ac.m_43908_()) {
                removed.add(item.m_41720_());
            }
        }
        ListIterator<PotionBrewing.Mix<Item>> mixIt = PotionBrewingAccessor.getContainerMixes().listIterator();
        while (mixIt.hasNext()) {
            PotionBrewing.Mix<Item> mix = mixIt.next();
            Item output = this.getOutputItemFromMix(mix);
            if (!ingredient.test(output.m_7968_())) continue;
            mixIt.remove();
            removed.add(output);
        }
        for (Item item : removed) {
            ConsoleJS.STARTUP.info((Object)("Removed potion container: " + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)item))));
        }
    }

    public void validateContainer(Item from, Ingredient ingredient, Item output) {
        Preconditions.checkArgument((from != null && from != Items.f_41852_ ? 1 : 0) != 0, (Object)"Input must not be null or air");
        Preconditions.checkNotNull((Object)ingredient, (Object)"Ingredient must not be null");
        Preconditions.checkArgument((ingredient.m_43908_().length > 0 ? 1 : 0) != 0, (Object)"Ingredient must have at least one item");
        Preconditions.checkArgument((output != null && output != Items.f_41852_ ? 1 : 0) != 0, (Object)"Output must not be null or air");
    }

    public abstract void addContainerRecipe(Item var1, Ingredient var2, Item var3);
}

