/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.inventory.CopperAnvilMenu;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CopperAnvil
extends AnvilBlock
implements IWeatheringBlock {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.repair");
    private final WeatheringCopper.WeatherState weatherState;
    public static Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK;

    private static void buildAnvilMap() {
        if (NEXT_BY_BLOCK == null) {
            NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)ModBlocks.COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.CHIPPED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.CHIPPED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.DAMAGED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_EXPOSED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_EXPOSED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_WEATHERED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_WEATHERED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_CHIPPED_OXIDIZED_COPPER_ANVIL.get())).put((Object)((Block)ModBlocks.WAXED_CHIPPED_OXIDIZED_COPPER_ANVIL.get()), (Object)((Block)ModBlocks.WAXED_DAMAGED_OXIDIZED_COPPER_ANVIL.get())).build());
        }
    }

    public CopperAnvil(WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = state;
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        this.m_220947_(blockState, level, blockPos, random);
    }

    public boolean m_6724_(BlockState blockState) {
        return IWeatheringBlock.getNext(blockState.m_60734_()).isPresent() || super.m_6724_(blockState);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockpos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult res = this.applyWax(blockState, level, blockpos, player, hand);
        return res.equals((Object)InteractionResult.PASS) ? super.m_6227_(blockState, level, blockpos, player, hand, hitResult) : res;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new CopperAnvilMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    @Nullable
    public static BlockState m_48824_(BlockState blockState) {
        CopperAnvil.buildAnvilMap();
        Optional<BlockState> next = Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)blockState.m_60734_())).map(block -> block.m_152465_(blockState));
        return next.orElse(null);
    }
}

