/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.VoidTotem;
import com.affehund.voidtotem.core.ILivingEntityMixin;
import com.affehund.voidtotem.mixin.ServerGamePacketListenerImplAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;

public class ModUtils {
    public static boolean isModLoaded(String modId) {
        return VoidTotem.PLATFORM.isModLoaded(modId);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canProtectFromVoid(LivingEntity livingEntity, DamageSource source) {
        currentDim = livingEntity.m_9236_().m_46472_().m_135782_().toString();
        isBlacklistedDimension = VoidTotem.PLATFORM.isInvertedBlacklist() != VoidTotem.PLATFORM.getBlacklistedDimensions().contains(currentDim);
        v0 = isInVoid = source.m_269533_(DamageTypeTags.f_268738_) != false && livingEntity.m_20186_() < (double)livingEntity.m_9236_().m_141937_();
        if (!(livingEntity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)livingEntity;
        if (((ServerGamePacketListenerImplAccessor)player.f_8906_).getAwaitingPositionFromClient() != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = isAwaitingPositionFromClient = false;
        }
        if (!isBlacklistedDimension && isInVoid && !isAwaitingPositionFromClient && (itemStack = ModUtils.getTotemItemStack(livingEntity)) != null) {
            result = VoidTotem.PLATFORM.getVoidTotemEventResult(itemStack, livingEntity, source);
            if (result.equals((Object)InteractionResult.CONSUME)) {
                return false;
            }
            if (result.equals((Object)InteractionResult.CONSUME_PARTIAL)) {
                return true;
            }
            if (livingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.f_8906_).setAboveGroundTickCount(0);
                ModUtils.giveUseStatAndCriterion(itemStack, player);
            }
            itemStack = ModUtils.damageOrShrinkItemStack(itemStack, livingEntity);
            if (livingEntity.m_20160_()) {
                livingEntity.m_20153_();
            }
            livingEntity.m_8127_();
            livingEntity.m_21153_(1.0f);
            ((ILivingEntityMixin)livingEntity).setFallDamageImmune(true);
            ModUtils.addTotemEffects(livingEntity);
            ModUtils.teleportToSavePosition(livingEntity);
            VoidTotem.PLATFORM.sendTotemEffectPacket(itemStack, livingEntity);
            return true;
        }
        return false;
    }

    public static ItemStack getTotemItemStack(LivingEntity livingEntity) {
        if (VoidTotem.PLATFORM.needsTotem()) {
            List<ItemStack> possibleTotemStacks = ModUtils.filterPossibleTotemStacks(ModUtils.getTotemFromTrinkets(livingEntity), ModUtils.getTotemFromInventory(livingEntity), ModUtils.getTotemFromHands(livingEntity));
            return possibleTotemStacks.stream().findFirst().orElse(null);
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> filterPossibleTotemStacks(ItemStack ... stacks) {
        return Arrays.stream(stacks).filter(Objects::nonNull).toList();
    }

    public static ItemStack getTotemFromTrinkets(LivingEntity livingEntity) {
        return VoidTotem.PLATFORM.getTotemFromAdditionalSlot(livingEntity, ModUtils::isVoidTotemOrAdditionalTotem);
    }

    public static ItemStack getTotemFromInventory(LivingEntity livingEntity) {
        if (VoidTotem.PLATFORM.useTotemFromInventory() && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!ModUtils.isVoidTotemOrAdditionalTotem(itemStack)) continue;
                return itemStack;
            }
        }
        return null;
    }

    public static ItemStack getTotemFromHands(LivingEntity livingEntity) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = livingEntity.m_21120_(hand);
            if (!ModUtils.isVoidTotemOrAdditionalTotem(itemStack)) continue;
            return itemStack;
        }
        return null;
    }

    public static boolean isVoidTotemOrAdditionalTotem(ItemStack itemStack) {
        boolean isVoidTotem = itemStack.m_41720_().equals(VoidTotem.PLATFORM.getVoidTotemItem());
        boolean isAdditionalTotem = itemStack.m_204117_(ModConstants.ADDITIONAL_TOTEMS_TAG);
        return isVoidTotem || isAdditionalTotem;
    }

    public static ItemStack damageOrShrinkItemStack(ItemStack itemStack, LivingEntity livingEntity) {
        ItemStack copiedStack = itemStack.m_41777_();
        if (itemStack.m_41763_()) {
            itemStack.m_41622_(1, livingEntity, e -> e.m_21190_(livingEntity.m_7655_()));
        } else {
            itemStack.m_41774_(1);
        }
        return copiedStack;
    }

    public static void giveUseStatAndCriterion(ItemStack itemStack, ServerPlayer player) {
        if (!itemStack.m_41619_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            CriteriaTriggers.f_10551_.m_74431_(player, itemStack);
        }
    }

    public static void teleportToSavePosition(LivingEntity livingEntity) {
        BlockPos nearLastPos = ModUtils.getNearLastPos(livingEntity);
        if (nearLastPos != null) {
            livingEntity.m_6021_((double)nearLastPos.m_123341_(), (double)nearLastPos.m_123342_(), (double)nearLastPos.m_123343_());
        } else {
            BlockPos currentPos = livingEntity.m_20183_();
            livingEntity.m_6021_((double)currentPos.m_123341_(), (double)(livingEntity.m_9236_().m_151558_() + VoidTotem.PLATFORM.teleportHeightOffset()), (double)currentPos.m_123343_());
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.f_8906_).setAboveGroundTickCount(0);
            }
        }
    }

    public static BlockPos getNearLastPos(LivingEntity livingEntity) {
        BlockPos lastPos = BlockPos.m_122022_((long)((ILivingEntityMixin)livingEntity).getLastSaveBlockPosAsLong());
        BlockPos teleportPos = null;
        Level level = livingEntity.m_9236_();
        DimensionType lastSaveBlockDim = ((ILivingEntityMixin)livingEntity).getLastSaveBlockDim();
        if (lastSaveBlockDim != null && lastSaveBlockDim == level.m_6042_()) {
            for (int i = 0; i < 16; ++i) {
                double x = (double)lastPos.m_123341_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
                double y = Mth.m_14008_((double)((double)lastPos.m_123342_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_151558_() - 1));
                double z = (double)lastPos.m_123343_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
                BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                if (!livingEntity.m_20984_(x, y, z, false)) continue;
                teleportPos = pos;
                break;
            }
        }
        return teleportPos;
    }

    public static void playActivateAnimation(ItemStack itemStack, Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91061_.m_107332_(entity, VoidTotem.PLATFORM.getVoidTotemParticle(), 30);
        ClientLevel level = mc.f_91073_;
        if (level != null) {
            level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
        }
        if (entity == mc.f_91074_) {
            mc.f_91063_.m_109113_(itemStack);
        }
    }

    public static void addTotemEffects(LivingEntity livingEntity) {
        if (VoidTotem.PLATFORM.giveTotemEffects()) {
            livingEntity.m_21219_();
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
        }
    }

    public static void setLastSaveBlockPos(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        BlockPos currentPos = livingEntity.m_20183_();
        BlockPos lastPos = BlockPos.m_122022_((long)((ILivingEntityMixin)livingEntity).getLastSaveBlockPosAsLong());
        if (!(!ModUtils.isSaveBlockPos(level, currentPos.m_7495_()) || lastPos.equals((Object)currentPos) && ModUtils.isSaveBlockPos(level, lastPos.m_7495_()))) {
            ((ILivingEntityMixin)livingEntity).setLastSaveBlockPosAsLong(currentPos.m_121878_());
            ((ILivingEntityMixin)livingEntity).setLastSaveBlockDim(livingEntity.m_9236_().m_6042_());
        }
    }

    public static boolean isSaveBlockPos(@NotNull Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60796_((BlockGetter)level, pos);
    }

    public static void resetFallDamageImmunity(LivingEntity livingEntity) {
        if (((ILivingEntityMixin)livingEntity).isFallDamageImmune()) {
            boolean canPlayerFly = false;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.f_8906_).setAboveGroundTickCount(0);
                Abilities abilities = player.m_150110_();
                if (abilities.f_35935_ || abilities.f_35936_) {
                    canPlayerFly = true;
                }
            }
            boolean isInWater = livingEntity.m_20069_();
            boolean isInCobweb = livingEntity.m_9236_().m_8055_(livingEntity.m_20183_()).m_60734_().equals(Blocks.f_50033_);
            if (canPlayerFly || isInCobweb || isInWater) {
                ((ILivingEntityMixin)livingEntity).setFallDamageImmune(false);
            }
        }
    }
}

