/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler.network.packet;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.item.ItemExchangerBase;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketSetFuzzyPlacementChance {
    private int chance;

    public PacketSetFuzzyPlacementChance(int chance) {
        this.chance = chance;
    }

    public PacketSetFuzzyPlacementChance(FriendlyByteBuf buffer) {
        this.chance = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.chance);
    }

    public static void handle(PacketSetFuzzyPlacementChance message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ItemStack heldItem;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && !(heldItem = player.m_21205_()).m_41619_() && heldItem.m_41720_() instanceof ItemExchangerBase) {
                ExchangerHandler.setFuzzyPlacementChance(heldItem, message.chance);
            }
        });
        context.get().setPacketHandled(true);
    }
}

