/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.event;

import com.github.jarva.allthearcanistgear.common.armor.AddonArmorItem;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="allthearcanistgear", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorEvents {
    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        ArmorEvents.processArmorEvent(event.getEntity(), EquipmentSlot.FEET, () -> true, ArmorSetConfig::preventFallDamage, () -> event.setCanceled(true));
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        if (event.getEntity().m_20193_().m_5776_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.HEAD, () -> event.getSource().m_269533_(DamageTypeTags.f_268581_), ArmorSetConfig::preventKinetic, () -> {
            entity.m_20301_(entity.m_6062_());
            event.setCanceled(true);
        });
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.HEAD, () -> event.getSource().m_276093_(DamageTypes.f_268576_), ArmorSetConfig::preventKinetic, () -> event.setCanceled(true));
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.CHEST, () -> event.getSource().m_269533_(DamageTypeTags.f_268745_), ArmorSetConfig::preventFire, () -> event.setCanceled(true));
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.CHEST, () -> event.getSource().m_276093_(DamageTypes.f_268482_), ArmorSetConfig::preventDragonsBreath, () -> event.setCanceled(true));
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.LEGS, () -> event.getSource().m_276093_(DamageTypes.f_268493_), ArmorSetConfig::preventWither, () -> event.setCanceled(true));
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.LEGS, () -> instance.m_19544_().equals(MobEffects.f_19615_), ArmorSetConfig::preventWither, () -> event.setResult(Event.Result.DENY));
        ArmorEvents.processArmorEvent(entity, EquipmentSlot.LEGS, () -> instance.m_19544_().equals(MobEffects.f_19620_), ArmorSetConfig::preventLevitation, () -> event.setResult(Event.Result.DENY));
    }

    private static void processArmorEvent(LivingEntity entity, EquipmentSlot slot, Supplier<Boolean> predicate, Function<ArmorSetConfig, Supplier<Boolean>> configFn, Runnable cancel) {
        AddonArmorItem armorItem;
        Item item = entity.m_6844_(slot).m_41720_();
        if (item instanceof AddonArmorItem && configFn.apply((armorItem = (AddonArmorItem)item).getConfig()).get().booleanValue() && predicate.get().booleanValue()) {
            cancel.run();
        }
    }
}

