/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.armor;

import com.github.jarva.allthearcanistgear.client.renderers.AddonArmorRenderer;
import com.github.jarva.allthearcanistgear.client.renderers.AddonGenericArmorModel;
import com.github.jarva.allthearcanistgear.common.armor.ArcanistMaterial;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AddonArmorItem
extends ArmorItem
implements GeoItem {
    private final int tier;
    private final GenericModel<AddonArmorItem> model;
    private final ArmorSetConfig config;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AddonArmorItem(ArmorSetConfig config, ArmorItem.Type slot, int tier) {
        super((ArmorMaterial)ArcanistMaterial.INSTANCE, slot, ItemsRegistry.defaultItemProperties().m_41487_(1).m_41486_().m_41497_(Rarity.EPIC));
        this.tier = tier;
        this.config = config;
        this.model = new AddonGenericArmorModel(config.name()).withEmptyAnim();
    }

    public void m_142312_(CompoundTag compoundTag) {
        super.m_142312_(compoundTag);
        compoundTag.m_128469_("an_stack_perks").m_128405_("tier", this.tier);
    }

    public ArmorSetConfig getConfig() {
        return this.config;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, world, tooltipComponents, tooltipFlag);
        IPerkProvider data = PerkRegistry.getPerkProvider((Item)this);
        if (data != null) {
            IPerkHolder iPerkHolder = data.getPerkHolder((Object)stack);
            if (iPerkHolder instanceof ArmorPerkHolder) {
                ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)iPerkHolder;
                tooltipComponents.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{armorPerkHolder.getTier() + 1}).m_130940_(ChatFormatting.GOLD));
            }
            data.getPerkHolder((Object)stack).appendPerkTooltip(tooltipComponents, (Object)stack);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private AddonArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new AddonArmorRenderer(AddonArmorItem.this.getArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    private GeoModel<AddonArmorItem> getArmorModel() {
        return this.model;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(this.m_7167_(slot));
        if (slot != this.m_40402_()) {
            return attributes.build();
        }
        IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)stack);
        if (perkHolder == null) {
            return attributes.build();
        }
        for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
            IPerk perk = perkInstance.getPerk();
            attributes.putAll(perk.getModifiers(slot, stack, perkInstance.getSlot().value));
        }
        return attributes.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != this.m_40402_()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            return builder.build();
        }
        return this.config.buildAttributeMap(this);
    }
}

