/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.measurements.client.BoxHandler;
import com.mrbysco.measurements.client.LineRenderType;
import com.mrbysco.measurements.config.TextColor;
import com.mrbysco.measurements.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MeasurementBox {
    private final BlockPos startPos;
    private BlockPos endPos;
    public AABB box;
    private final ResourceKey<Level> dimensionKey;
    private boolean finished;
    private final DyeColor lineColor;
    private final DyeColor textX;
    private final DyeColor textY;
    private final DyeColor textZ;

    MeasurementBox(BlockPos block, ResourceKey<Level> dimensionKey) {
        this.startPos = block;
        this.endPos = block;
        this.dimensionKey = dimensionKey;
        this.finished = false;
        this.lineColor = Services.PLATFORM.getLineColor().getColor(BoxHandler.random);
        TextColor textColor = Services.PLATFORM.getTextColor();
        if (textColor == TextColor.XYZRGB) {
            this.textX = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.X);
            this.textY = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.Y);
            this.textZ = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.Z);
        } else {
            DyeColor color;
            this.textX = color = textColor.getColor(BoxHandler.random, null);
            this.textY = color;
            this.textZ = color;
        }
        this.setBoundingBox();
    }

    private void setBoundingBox() {
        int ax = this.startPos.m_123341_();
        int ay = this.startPos.m_123342_();
        int az = this.startPos.m_123343_();
        int bx = this.endPos.m_123341_();
        int by = this.endPos.m_123342_();
        int bz = this.endPos.m_123343_();
        this.box = new AABB((double)Math.min(ax, bx), (double)Math.min(ay, by), (double)Math.min(az, bz), (double)(Math.max(ax, bx) + 1), (double)(Math.max(ay, by) + 1), (double)(Math.max(az, bz) + 1));
    }

    public void setBlockEnd(BlockPos blockEnd) {
        this.endPos = blockEnd;
        this.setBoundingBox();
    }

    public void render(ResourceKey<Level> currentDimensionKey, PoseStack poseStack, RenderBuffers renderBuffers, Camera camera, Matrix4f projection) {
        if (!this.dimensionKey.m_135782_().equals((Object)currentDimensionKey.m_135782_())) {
            return;
        }
        float[] color = this.lineColor.m_41068_();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        float a = 0.95f;
        Vec3 pos = camera.m_90583_();
        double distance = this.box.m_82399_().m_82554_(pos);
        float lineWidth = Services.PLATFORM.getLineWidth();
        if (distance > 48.0) {
            lineWidth = Services.PLATFORM.getLineWidthMax();
        }
        MultiBufferSource.BufferSource bufferSource = renderBuffers.m_110104_();
        poseStack.m_85836_();
        RenderType renderType = LineRenderType.lineRenderType(lineWidth);
        VertexConsumer builder = bufferSource.m_6299_(renderType);
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)builder, (AABB)this.box, (float)r, (float)g, (float)b, (float)0.95f);
        bufferSource.m_109912_(renderType);
        poseStack.m_85849_();
        this.drawLength(poseStack, camera, projection, bufferSource);
    }

    private void drawLength(PoseStack poseStack, Camera camera, Matrix4f projection, MultiBufferSource.BufferSource bufferSource) {
        int lengthX = (int)this.box.m_82362_();
        int lengthY = (int)this.box.m_82376_();
        int lengthZ = (int)this.box.m_82385_();
        Vec3 pos = camera.m_90583_();
        Frustum clippingHelper = new Frustum(poseStack.m_85850_().m_252922_(), projection);
        clippingHelper.m_113002_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        AABB boxT = this.box.m_82400_((double)0.08f);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82289_, boxT.f_82290_, boxT.f_82288_, boxT.f_82289_, boxT.f_82293_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82292_, boxT.f_82290_, boxT.f_82288_, boxT.f_82292_, boxT.f_82293_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82291_, boxT.f_82289_, boxT.f_82290_, boxT.f_82291_, boxT.f_82289_, boxT.f_82293_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82291_, boxT.f_82292_, boxT.f_82290_, boxT.f_82291_, boxT.f_82292_, boxT.f_82293_), pos, clippingHelper));
        Collections.sort(lines);
        Vec3 lineZ = ((Line)lines.get((int)0)).line.m_82399_();
        lines.clear();
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82289_, boxT.f_82290_, boxT.f_82288_, boxT.f_82292_, boxT.f_82290_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82289_, boxT.f_82293_, boxT.f_82288_, boxT.f_82292_, boxT.f_82293_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82291_, boxT.f_82289_, boxT.f_82290_, boxT.f_82291_, boxT.f_82292_, boxT.f_82290_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82291_, boxT.f_82289_, boxT.f_82293_, boxT.f_82291_, boxT.f_82292_, boxT.f_82293_), pos, clippingHelper));
        Collections.sort(lines);
        Vec3 lineY = ((Line)lines.get((int)0)).line.m_82399_();
        lines.clear();
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82289_, boxT.f_82290_, boxT.f_82291_, boxT.f_82289_, boxT.f_82290_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82289_, boxT.f_82293_, boxT.f_82291_, boxT.f_82289_, boxT.f_82293_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82292_, boxT.f_82290_, boxT.f_82291_, boxT.f_82292_, boxT.f_82290_), pos, clippingHelper));
        lines.add(Line.createLine(new AABB(boxT.f_82288_, boxT.f_82292_, boxT.f_82293_, boxT.f_82291_, boxT.f_82292_, boxT.f_82293_), pos, clippingHelper));
        Collections.sort(lines);
        Vec3 lineX = ((Line)lines.get((int)0)).line.m_82399_();
        lines.clear();
        poseStack.m_85836_();
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        this.drawText(poseStack, camera, new Vec3(lineX.f_82479_, lineX.f_82480_, lineX.f_82481_), (Component)Component.m_237113_((String)String.valueOf(lengthX)), this.textX, bufferSource);
        this.drawText(poseStack, camera, new Vec3(lineY.f_82479_, lineY.f_82480_, lineY.f_82481_), (Component)Component.m_237113_((String)String.valueOf(lengthY)), this.textY, bufferSource);
        this.drawText(poseStack, camera, new Vec3(lineZ.f_82479_, lineZ.f_82480_, lineZ.f_82481_), (Component)Component.m_237113_((String)String.valueOf(lengthZ)), this.textZ, bufferSource);
        poseStack.m_85849_();
    }

    private void drawText(PoseStack poseStack, Camera camera, Vec3 pos, Component length, DyeColor textColor, MultiBufferSource.BufferSource bufferSource) {
        Font font = Minecraft.m_91087_().f_91062_;
        float size = Services.PLATFORM.getTextSize();
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_ + (double)size * 5.0, pos.f_82481_);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-size, -size, -size);
        poseStack.m_252880_((float)(-font.m_92852_((FormattedText)length)) / 2.0f, 0.0f, 0.0f);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        font.m_272077_(length, 0.0f, 0.0f, textColor.m_41071_(), false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    private record Line(AABB line, boolean isVisible, double distance) implements Comparable<Line>
    {
        public static Line createLine(AABB line, Vec3 pos, Frustum clippingHelper) {
            return new Line(line, clippingHelper.m_113029_(line), line.m_82399_().m_82554_(pos));
        }

        @Override
        public int compareTo(@NotNull Line l) {
            if (this.isVisible) {
                return l.isVisible ? Double.compare(this.distance, l.distance) : -1;
            }
            return l.isVisible ? 1 : 0;
        }
    }
}

